/*
 * Decompiled with CFR 0.152.
 */
package network;

import io.netty.bootstrap.Bootstrap;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.timeout.IdleStateHandler;
import io.netty.util.AttributeKey;
import io.netty.util.concurrent.Future;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import network.Host;
import network.IMessageConsumer;
import network.INetwork;
import network.INodeListener;
import network.ISerializer;
import network.NetworkConfiguration;
import network.PeerOutConnection;
import network.messaging.NetworkMessage;
import network.messaging.control.ControlMessage;
import network.pipeline.InExceptionHandler;
import network.pipeline.InHandshakeHandler;
import network.pipeline.MessageDecoder;
import network.pipeline.MessageEncoder;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class NetworkService
implements INetwork {
    private static final Logger logger = LogManager.getLogger(NetworkService.class);
    public static final AttributeKey<Boolean> TRANSIENT_KEY = AttributeKey.valueOf((String)"transient");
    private Bootstrap clientBootstrap;
    private Channel serverChannel;
    private final Host myHost;
    private Map<Host, PeerOutConnection> knownPeers = new ConcurrentHashMap<Host, PeerOutConnection>();
    private Set<INodeListener> nodeListeners = ConcurrentHashMap.newKeySet();
    private Map<Short, ISerializer> serializers = new ConcurrentHashMap<Short, ISerializer>();
    private Map<Short, IMessageConsumer> messageConsumers = new ConcurrentHashMap<Short, IMessageConsumer>();
    private EventLoopGroup workerGroup;
    private NetworkConfiguration config;

    public NetworkService(Properties props) throws Exception {
        this.config = new NetworkConfiguration(props);
        this.myHost = this.readHost();
        this.clientBootstrap = this.setupClientBootstrap();
        this.serverChannel = this.startServer(this.myHost.getPort());
        this.serializers.put((short)0, ControlMessage.serializer);
        Runtime.getRuntime().addShutdownHook(new Thread(() -> logger.debug("Killed")));
    }

    @Override
    public Host myHost() {
        return this.myHost;
    }

    @Override
    public void registerNodeListener(INodeListener listener) {
        this.nodeListeners.add(listener);
    }

    @Override
    public void registerConsumer(short msgCode, IMessageConsumer consumer) {
        if (this.messageConsumers.putIfAbsent(msgCode, consumer) != null) {
            throw new AssertionError((Object)("Trying to re-register consumer in NetworkService: " + msgCode));
        }
    }

    @Override
    public void registerSerializer(short msgCode, ISerializer serializer) {
        if (this.serializers.putIfAbsent(msgCode, serializer) != null) {
            throw new AssertionError((Object)("Trying to re-register serializer in NetworkService" + msgCode));
        }
    }

    @Override
    public void addPeer(Host peer) {
        PeerOutConnection conn = this.knownPeers.computeIfAbsent(peer, k -> new PeerOutConnection((Host)k, this.myHost, this.clientBootstrap, this.nodeListeners, this.serializers, this.config, this.workerGroup.next()));
        conn.connect();
    }

    @Override
    public void removePeer(Host peerHost) {
        PeerOutConnection conn = this.knownPeers.get(peerHost);
        if (conn != null) {
            conn.disconnect();
        }
    }

    @Override
    public boolean isConnectionActive(Host peerHost) {
        PeerOutConnection conn = this.knownPeers.get(peerHost);
        return conn != null && conn.getStatus() == PeerOutConnection.Status.ACTIVE;
    }

    @Override
    public void sendMessage(short msgCode, Object payload, Host to, boolean newChannel) {
        if (to.equals(this.myHost)) {
            this.messageConsumers.get(msgCode).deliverMessage(msgCode, payload, this.myHost);
            return;
        }
        PeerOutConnection connection = this.knownPeers.computeIfAbsent(to, k -> new PeerOutConnection((Host)k, this.myHost, this.clientBootstrap, this.nodeListeners, this.serializers, this.config, this.workerGroup.next()));
        NetworkMessage networkMessage = new NetworkMessage(msgCode, payload);
        if (newChannel) {
            connection.sendMessageTransientChannel(networkMessage);
        } else {
            connection.sendMessage(networkMessage);
        }
    }

    @Override
    public void sendMessage(short msgCode, Object payload, Host to) {
        this.sendMessage(msgCode, payload, to, false);
    }

    @Override
    public void broadcastMessage(short msgCode, Object payload, Iterator<Host> targets) {
        while (targets.hasNext()) {
            Host h = targets.next();
            this.sendMessage(msgCode, payload, h);
        }
    }

    private Channel startServer(int port) throws Exception {
        NioEventLoopGroup bossGroup = new NioEventLoopGroup();
        NioEventLoopGroup workerGroup = new NioEventLoopGroup();
        ServerBootstrap b = new ServerBootstrap();
        b.group((EventLoopGroup)bossGroup, (EventLoopGroup)workerGroup).channel(NioServerSocketChannel.class);
        b.childHandler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            public void initChannel(SocketChannel ch) {
                ch.pipeline().addLast("IdleStateHandler", (ChannelHandler)new IdleStateHandler(0L, (long)((NetworkService)NetworkService.this).config.HEARTBEAT_INTERVAL_MILLIS, 0L, TimeUnit.MILLISECONDS));
                ch.pipeline().addLast("MessageDecoder", (ChannelHandler)new MessageDecoder(NetworkService.this.serializers));
                ch.pipeline().addLast("MessageEncoder", (ChannelHandler)new MessageEncoder(NetworkService.this.serializers));
                ch.pipeline().addLast("InHandshakeHandler", (ChannelHandler)new InHandshakeHandler(NetworkService.this.messageConsumers));
                ch.pipeline().addLast("InEventExceptionHandler", (ChannelHandler)new InExceptionHandler());
            }
        });
        b.option(ChannelOption.SO_BACKLOG, (Object)128);
        b.childOption(ChannelOption.SO_KEEPALIVE, (Object)true);
        b.childOption(ChannelOption.TCP_NODELAY, (Object)true);
        ChannelFuture f = b.bind(port).sync();
        logger.debug("Server started in port " + port);
        f.channel().closeFuture().addListener(arg_0 -> NetworkService.lambda$startServer$3((EventLoopGroup)workerGroup, (EventLoopGroup)bossGroup, arg_0));
        return f.channel();
    }

    private Bootstrap setupClientBootstrap() {
        this.workerGroup = new NioEventLoopGroup();
        Bootstrap newClientBootstrap = new Bootstrap();
        newClientBootstrap.channel(NioSocketChannel.class);
        newClientBootstrap.option(ChannelOption.SO_KEEPALIVE, (Object)true);
        newClientBootstrap.option(ChannelOption.TCP_NODELAY, (Object)true);
        newClientBootstrap.option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)this.config.CONNECT_TIMEOUT_MILLIS);
        return newClientBootstrap;
    }

    private Host readHost() throws Exception {
        short myPort = this.config.LISTEN_BASE_PORT;
        String ip = this.config.LISTEN_ADDRESS;
        InetAddress myIp = ip != null && !ip.isEmpty() ? InetAddress.getByName(ip) : NetworkService.getNetworkInterfaceAddress(this.config.LISTEN_INTERFACE);
        if (myIp == null) {
            throw new Exception("Error getting local ip address");
        }
        return new Host(myIp, myPort);
    }

    private static InetAddress getNetworkInterfaceAddress(String interfaceName) throws Exception {
        try {
            NetworkInterface ni = NetworkInterface.getByName(interfaceName);
            if (ni == null) {
                throw new Exception("Interface " + interfaceName + " could not be found");
            }
            Enumeration<InetAddress> addresses = ni.getInetAddresses();
            if (!addresses.hasMoreElements()) {
                throw new Exception("Interface " + interfaceName + " was found, but had no addresses");
            }
            while (addresses.hasMoreElements()) {
                InetAddress temp = addresses.nextElement();
                if (!(temp instanceof Inet4Address)) continue;
                return temp;
            }
            return null;
        }
        catch (SocketException e) {
            throw new Exception("Interface " + interfaceName + " caused an exception", e);
        }
    }

    private static /* synthetic */ void lambda$startServer$3(EventLoopGroup workerGroup, EventLoopGroup bossGroup, Future cf) throws Exception {
        workerGroup.shutdownGracefully();
        bossGroup.shutdownGracefully();
    }
}

