/*
 * Decompiled with CFR 0.152.
 */
package network;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.EventLoop;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.timeout.ReadTimeoutHandler;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;
import network.Host;
import network.INodeListener;
import network.ISerializer;
import network.NetworkConfiguration;
import network.NetworkService;
import network.messaging.NetworkMessage;
import network.pipeline.MessageDecoder;
import network.pipeline.MessageEncoder;
import network.pipeline.OutExceptionHandler;
import network.pipeline.OutHandshakeHandler;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PeerOutConnection
extends ChannelInitializer<SocketChannel>
implements GenericFutureListener<ChannelFuture> {
    private static final Logger logger = LogManager.getLogger(PeerOutConnection.class);
    private EventLoop loop;
    private volatile Status status;
    private int reconnectAttempts;
    private boolean outsideNodeUp;
    private Channel channel;
    private final Host peerHost;
    private final Host myHost;
    private final Queue<NetworkMessage> messageLog;
    private final Bootstrap clientBootstrap;
    private Map<Channel, NetworkMessage> transientChannels;
    private Map<Short, ISerializer> serializers;
    private Set<INodeListener> nodeListeners;
    private NetworkConfiguration config;

    PeerOutConnection(Host peerHost, Host myHost, Bootstrap bootstrap, Set<INodeListener> nodeListeners, Map<Short, ISerializer> serializers, NetworkConfiguration config, EventLoop loop) {
        this.peerHost = peerHost;
        this.myHost = myHost;
        this.nodeListeners = nodeListeners;
        this.serializers = serializers;
        this.config = config;
        this.loop = loop;
        this.status = Status.DISCONNECTED;
        this.channel = null;
        this.transientChannels = new ConcurrentHashMap<Channel, NetworkMessage>();
        this.reconnectAttempts = 0;
        this.clientBootstrap = bootstrap.clone();
        this.clientBootstrap.remoteAddress(peerHost.getAddress(), peerHost.getPort());
        this.clientBootstrap.handler((ChannelHandler)this);
        this.clientBootstrap.group((EventLoopGroup)loop);
        this.outsideNodeUp = false;
        this.messageLog = new ConcurrentLinkedQueue<NetworkMessage>();
    }

    void connect() {
        this.loop.execute(() -> {
            if (this.status == Status.DISCONNECTED) {
                logger.debug("Connecting to " + this.peerHost);
                this.status = Status.RETRYING;
                this.reconnect();
            }
        });
    }

    private void reconnect() {
        if (this.status == Status.DISCONNECTED) {
            return;
        }
        assert (this.loop.inEventLoop());
        assert (this.status == Status.RETRYING);
        ++this.reconnectAttempts;
        if (this.channel != null && this.channel.isOpen()) {
            throw new AssertionError((Object)("Channel open in reconnect: " + this.peerHost));
        }
        this.channel = ((Bootstrap)this.clientBootstrap.attr(NetworkService.TRANSIENT_KEY, (Object)false)).connect().channel();
        this.channel.closeFuture().addListener((GenericFutureListener)this);
    }

    public void channelActiveCallback(Channel c) {
        assert (this.loop.inEventLoop());
        if (((Boolean)c.attr(NetworkService.TRANSIENT_KEY).get()).booleanValue()) {
            return;
        }
        if (this.status != Status.RETRYING || c != this.channel) {
            throw new AssertionError((Object)("Channel active without being in disconnected state: " + this.peerHost));
        }
        this.status = Status.HANDSHAKING;
    }

    public void handshakeCompletedCallback(Channel c) {
        assert (this.loop.inEventLoop());
        if (((Boolean)c.attr(NetworkService.TRANSIENT_KEY).get()).booleanValue()) {
            NetworkMessage networkMessage = this.transientChannels.remove(c);
            assert (networkMessage != null);
            c.writeAndFlush((Object)networkMessage);
            return;
        }
        if (this.status != Status.HANDSHAKING || c != this.channel) {
            throw new AssertionError((Object)("Handshake completed without being in handshake state: " + this.peerHost));
        }
        this.status = Status.ACTIVE;
        logger.debug("Handshake completed to: " + c.remoteAddress());
        this.writeMessageLog();
        if (!this.outsideNodeUp) {
            this.outsideNodeUp = true;
            this.nodeListeners.forEach(l -> l.nodeUp(this.peerHost));
        } else {
            logger.warn("Node connection reestablished: " + this.peerHost);
            this.nodeListeners.forEach(l -> l.nodeConnectionReestablished(this.peerHost));
        }
        this.reconnectAttempts = 0;
    }

    private void writeMessageLog() {
        NetworkMessage msg;
        assert (this.loop.inEventLoop());
        if (this.status == Status.DISCONNECTED) {
            logger.error("Writing message " + this.messageLog.poll() + " to disconnected channel " + this.peerHost);
            return;
        }
        int count = 0;
        while (this.channel.isActive() && (msg = this.messageLog.poll()) != null) {
            logger.debug("Writing " + msg + " to outChannel of " + this.peerHost);
            this.channel.write((Object)msg);
            ++count;
        }
        if (count > 0) {
            this.channel.flush();
        }
    }

    public void operationComplete(ChannelFuture future) {
        assert (this.loop.inEventLoop());
        if (future != this.channel.closeFuture()) {
            throw new AssertionError((Object)("Future called for not current channel: " + this.peerHost));
        }
        if (this.status == Status.DISCONNECTED) {
            return;
        }
        if (this.reconnectAttempts == this.config.RECONNECT_ATTEMPTS_BEFORE_DOWN && this.outsideNodeUp) {
            this.nodeListeners.forEach(n -> n.nodeDown(this.peerHost));
            this.outsideNodeUp = false;
        }
        assert (this.status == Status.RETRYING || this.status == Status.ACTIVE);
        this.status = Status.RETRYING;
        this.loop.schedule(this::reconnect, this.reconnectAttempts > this.config.RECONNECT_ATTEMPTS_BEFORE_DOWN ? (long)this.config.RECONNECT_INTERVAL_AFTER_DOWN_MILLIS : (long)this.config.RECONNECT_INTERVAL_BEFORE_DOWN_MILLIS, TimeUnit.MILLISECONDS);
    }

    void disconnect() {
        this.loop.execute(() -> {
            if (this.status != Status.DISCONNECTED) {
                logger.debug("Disconnecting channel to: " + this.peerHost);
                this.status = Status.DISCONNECTED;
                this.channel.close();
            }
        });
    }

    void sendMessage(NetworkMessage msg) {
        logger.debug("Adding " + msg + " to msgOutQueue of " + this.peerHost);
        this.messageLog.add(msg);
        this.loop.execute(this::writeMessageLog);
    }

    void sendMessageTransientChannel(NetworkMessage msg) {
        this.loop.execute(() -> {
            Channel transientChannel = ((Bootstrap)this.clientBootstrap.attr(NetworkService.TRANSIENT_KEY, (Object)true)).connect().channel();
            this.transientChannels.put(transientChannel, msg);
        });
    }

    Status getStatus() {
        return this.status;
    }

    protected void initChannel(SocketChannel ch) {
        ch.pipeline().addLast("ReadTimeoutHandler", (ChannelHandler)new ReadTimeoutHandler((long)this.config.IDLE_TIMEOUT_MILLIS, TimeUnit.MILLISECONDS));
        ch.pipeline().addLast("MessageDecoder", (ChannelHandler)new MessageDecoder(this.serializers));
        ch.pipeline().addLast("MessageEncoder", (ChannelHandler)new MessageEncoder(this.serializers));
        ch.pipeline().addLast("OutHandshakeHandler", (ChannelHandler)new OutHandshakeHandler(this.myHost, this));
        ch.pipeline().addLast("OutEventExceptionHandler", (ChannelHandler)new OutExceptionHandler());
    }

    static enum Status {
        DISCONNECTED,
        ACTIVE,
        HANDSHAKING,
        RETRYING;

    }
}

