/*
 * Decompiled with CFR 0.152.
 */
package network.pipeline;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToByteEncoder;
import java.util.Map;
import network.ISerializer;
import network.messaging.NetworkMessage;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MessageEncoder
extends MessageToByteEncoder<NetworkMessage> {
    private static final Logger logger = LogManager.getLogger(MessageEncoder.class);
    private Map<Short, ISerializer> serializers;

    public MessageEncoder(Map<Short, ISerializer> serializers) {
        this.serializers = serializers;
    }

    protected void encode(ChannelHandlerContext ctx, NetworkMessage msg, ByteBuf out) {
        ISerializer iSerializer = this.serializers.get(msg.code);
        out.writeInt(iSerializer.serializedSize(msg.payload) + 2);
        out.writeShort((int)msg.code);
        iSerializer.serialize(msg.payload, out);
        assert (out.writerIndex() == iSerializer.serializedSize(msg.payload) + 2 + 4);
    }
}

