/*
 * Decompiled with CFR 0.152.
 */
package network.messaging.control;

import io.netty.buffer.ByteBuf;
import java.net.UnknownHostException;
import network.ISerializer;
import network.messaging.control.FirstHandshakeMessage;
import network.messaging.control.HeartbeatMessage;

public abstract class ControlMessage {
    public static final short MSG_CODE = 0;
    public final Type type;
    private volatile int serializedSize = -1;
    public static final ISerializer<ControlMessage> serializer = new ISerializer<ControlMessage>(){

        @Override
        public void serialize(ControlMessage message, ByteBuf out) {
            out.writeInt(message.type.opcode);
            message.type.serializer.serialize(message, out);
        }

        @Override
        public ControlMessage deserialize(ByteBuf in) throws UnknownHostException {
            Type type = Type.fromOpcode(in.readInt());
            return (ControlMessage)type.serializer.deserialize(in);
        }

        @Override
        public int serializedSize(ControlMessage message) {
            if (message.serializedSize != -1) {
                return message.serializedSize;
            }
            int size = 4;
            message.serializedSize = (size += message.type.serializer.serializedSize(message));
            return size;
        }
    };

    ControlMessage(Type type) {
        this.type = type;
    }

    public static enum Type {
        HEARTBEAT(0, HeartbeatMessage.serializer),
        FIRST_HS(1, FirstHandshakeMessage.serializer);

        public final int opcode;
        private final ControlMessageSerializer<ControlMessage> serializer;
        private static final Type[] opcodeIdx;

        private Type(int opcode, ControlMessageSerializer<ControlMessage> serializer) {
            this.opcode = opcode;
            this.serializer = serializer;
        }

        public static Type fromOpcode(int opcode) {
            if (opcode >= opcodeIdx.length || opcode < 0) {
                throw new AssertionError((Object)String.format("Unknown opcode %d", opcode));
            }
            Type t = opcodeIdx[opcode];
            if (t == null) {
                throw new AssertionError((Object)String.format("Unknown opcode %d", opcode));
            }
            return t;
        }

        static {
            int maxOpcode = -1;
            for (Type type : Type.values()) {
                maxOpcode = Math.max(maxOpcode, type.opcode);
            }
            opcodeIdx = new Type[maxOpcode + 1];
            for (Type type : Type.values()) {
                if (opcodeIdx[type.opcode] != null) {
                    throw new IllegalStateException("Duplicate opcode");
                }
                Type.opcodeIdx[type.opcode] = type;
            }
        }
    }

    static interface ControlMessageSerializer<T extends ControlMessage>
    extends ISerializer<T> {
    }
}

