/*
 * Decompiled with CFR 0.152.
 */
package network.pipeline;

import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.handler.timeout.IdleState;
import io.netty.handler.timeout.IdleStateEvent;
import io.netty.util.concurrent.GenericFutureListener;
import network.messaging.NetworkMessage;
import network.messaging.control.HeartbeatMessage;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class InExceptionHandler
extends ChannelDuplexHandler {
    private static final Logger logger = LogManager.getLogger(InExceptionHandler.class);

    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) {
        ctx.write(msg, promise.addListener((GenericFutureListener)((ChannelFutureListener)future -> {
            if (!future.isSuccess()) {
                Throwable cause = future.cause();
                logger.error("Inbound connection exception: " + ctx.channel().remoteAddress().toString() + " " + cause);
                if (cause.getCause() instanceof AssertionError) {
                    cause.printStackTrace();
                    System.exit(1);
                }
                ctx.close();
            }
        })));
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) {
        IdleStateEvent e;
        if (evt instanceof IdleStateEvent && (e = (IdleStateEvent)evt).state() == IdleState.WRITER_IDLE) {
            ctx.channel().writeAndFlush((Object)new NetworkMessage(0, new HeartbeatMessage()));
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        logger.error("Inbound connection exception: " + ctx.channel().remoteAddress().toString() + " " + cause);
        ctx.close();
    }

    public void channelInactive(ChannelHandlerContext ctx) {
        logger.debug("Incoming connection from " + ctx.channel().remoteAddress() + " closed");
        ctx.fireChannelInactive();
    }
}

