/*
 * Decompiled with CFR 0.152.
 */
package network.pipeline;

import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import java.util.Map;
import network.IMessageConsumer;
import network.messaging.NetworkMessage;
import network.messaging.control.ControlMessage;
import network.messaging.control.FirstHandshakeMessage;
import network.pipeline.InConnectionHandler;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class InHandshakeHandler
extends ChannelDuplexHandler {
    private static final Logger logger = LogManager.getLogger(InHandshakeHandler.class);
    private Map<Short, IMessageConsumer> messageConsumers;

    public InHandshakeHandler(Map<Short, IMessageConsumer> messageConsumers) {
        this.messageConsumers = messageConsumers;
    }

    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) {
        ctx.write(msg, promise);
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) {
        NetworkMessage netMsg = (NetworkMessage)msg;
        ControlMessage payload = (ControlMessage)netMsg.payload;
        if (payload.type != ControlMessage.Type.FIRST_HS) {
            throw new AssertionError((Object)("Received unexpected message in handshake: " + msg));
        }
        FirstHandshakeMessage fhm = (FirstHandshakeMessage)payload;
        logger.debug("Incoming connection from: " + fhm.clientHost);
        ctx.pipeline().replace((ChannelHandler)this, "InConnectionHandler", (ChannelHandler)new InConnectionHandler(fhm.clientHost, this.messageConsumers));
    }
}

