/*
 * Decompiled with CFR 0.152.
 */
package network.pipeline;

import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import network.Host;
import network.PeerOutConnection;
import network.messaging.NetworkMessage;
import network.messaging.control.FirstHandshakeMessage;
import network.pipeline.OutConnectionHandler;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class OutHandshakeHandler
extends ChannelDuplexHandler {
    private static final Logger logger = LogManager.getLogger(OutHandshakeHandler.class);
    private Host myHost;
    private PeerOutConnection peerOutConnection;

    public OutHandshakeHandler(Host myHost, PeerOutConnection peerOutConnection) {
        this.myHost = myHost;
        this.peerOutConnection = peerOutConnection;
    }

    public void channelActive(ChannelHandlerContext ctx) {
        this.peerOutConnection.channelActiveCallback(ctx.channel());
        ChannelFuture channelFuture = ctx.channel().writeAndFlush((Object)new NetworkMessage(0, new FirstHandshakeMessage(this.myHost)));
        channelFuture.addListener(listener -> {
            ctx.channel().pipeline().replace((ChannelHandler)this, "OutConnectionHandler", (ChannelHandler)new OutConnectionHandler(ctx));
            this.peerOutConnection.handshakeCompletedCallback(ctx.channel());
        });
    }
}

