/*
 * Decompiled with CFR 0.152.
 */
package pt.unl.fct.di.novasys.channel.ackos;

import io.netty.util.concurrent.Promise;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Queue;
import java.util.stream.Collectors;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import pt.unl.fct.di.novasys.channel.ChannelListener;
import pt.unl.fct.di.novasys.channel.ackos.OutConnectionContext;
import pt.unl.fct.di.novasys.channel.ackos.events.NodeDownEvent;
import pt.unl.fct.di.novasys.channel.ackos.messaging.AckosAckMessage;
import pt.unl.fct.di.novasys.channel.ackos.messaging.AckosAppMessage;
import pt.unl.fct.di.novasys.channel.ackos.messaging.AckosMessage;
import pt.unl.fct.di.novasys.channel.ackos.messaging.AckosMessageSerializer;
import pt.unl.fct.di.novasys.channel.base.SingleThreadedBiChannel;
import pt.unl.fct.di.novasys.network.AttributeValidator;
import pt.unl.fct.di.novasys.network.Connection;
import pt.unl.fct.di.novasys.network.ISerializer;
import pt.unl.fct.di.novasys.network.NetworkManager;
import pt.unl.fct.di.novasys.network.data.Attributes;
import pt.unl.fct.di.novasys.network.data.Host;

public class AckosChannel<T>
extends SingleThreadedBiChannel<T, AckosMessage<T>>
implements AttributeValidator {
    private static final Logger logger = LogManager.getLogger(AckosChannel.class);
    private static final short ACKOS_MAGIC_NUMBER = 17669;
    private static final Attributes ACKOS_ATTRIBUTES = new Attributes();
    public static final int DEFAULT_PORT = 13174;
    private final NetworkManager<AckosMessage<T>> network;
    private final ChannelListener<T> listener;
    private Map<Host, Pair<Connection<AckosMessage<T>>, Queue<T>>> pendingConnections;
    private Map<Host, OutConnectionContext<T>> establishedConnections;

    public AckosChannel(ISerializer<T> serializer, ChannelListener<T> list, Properties properties) throws UnknownHostException {
        super("AckosChannel");
        this.listener = list;
        InetAddress addr = null;
        if (properties.containsKey("address")) {
            addr = Inet4Address.getByName(properties.getProperty("address"));
        }
        int port = 13174;
        if (properties.containsKey("port")) {
            port = Integer.parseInt(properties.getProperty("port"));
        }
        AckosMessageSerializer<T> tAckosMessageSerializer = new AckosMessageSerializer<T>(serializer);
        this.network = new NetworkManager<T>(tAckosMessageSerializer, this, 1000, 3000, 1000);
        if (addr != null) {
            this.network.createServerSocket(this, new Host(addr, port), this);
        }
        this.pendingConnections = new HashMap<Host, Pair<Connection<AckosMessage<T>>, Queue<T>>>();
        this.establishedConnections = new HashMap<Host, OutConnectionContext<T>>();
    }

    @Override
    protected void onSendMessage(T msg, Host peer, int connection) {
        OutConnectionContext<T> context = this.establishedConnections.get(peer);
        if (context != null) {
            Promise promise = this.loop.newPromise();
            promise.addListener(future -> {
                if (!future.isSuccess()) {
                    this.listener.messageFailed(msg, peer, future.cause());
                }
            });
            context.sendMessage(msg, (Promise<Void>)promise);
        } else {
            Pair pair = this.pendingConnections.computeIfAbsent(peer, k -> Pair.of(this.network.createConnection(peer, ACKOS_ATTRIBUTES, this), new LinkedList()));
            ((Queue)pair.getValue()).add(msg);
        }
    }

    @Override
    protected void onCloseConnection(Host peer, int connection) {
        OutConnectionContext<T> context;
        Pair<Connection<AckosMessage<T>>, Queue<T>> remove = this.pendingConnections.remove(peer);
        if (remove != null) {
            ((Connection)remove.getKey()).disconnect();
        }
        if ((context = this.establishedConnections.get(peer)) != null) {
            context.getConnection().disconnect();
        }
    }

    @Override
    protected void onOutboundConnectionUp(Connection<AckosMessage<T>> conn) {
        Pair<Connection<AckosMessage<T>>, Queue<T>> remove = this.pendingConnections.remove(conn.getPeer());
        if (remove != null) {
            logger.debug("Outbound established: " + conn);
            OutConnectionContext ctx = new OutConnectionContext(conn);
            OutConnectionContext<T> put = this.establishedConnections.put(conn.getPeer(), ctx);
            if (put != null) {
                throw new RuntimeException("Context exists in connection up");
            }
            for (Object t : (Queue)remove.getValue()) {
                Promise promise = this.loop.newPromise();
                promise.addListener(future -> {
                    if (!future.isSuccess()) {
                        this.listener.messageFailed(t, conn.getPeer(), future.cause());
                    }
                });
                ctx.sendMessage(t, (Promise<Void>)promise);
            }
        } else {
            logger.warn("ConnectionUp with no pending: " + conn);
        }
    }

    @Override
    protected void onOutboundConnectionDown(Connection<AckosMessage<T>> conn, Throwable cause) {
        OutConnectionContext<T> context = this.establishedConnections.remove(conn.getPeer());
        if (context != null) {
            List failed = context.getPending().stream().map(Pair::getValue).collect(Collectors.toList());
            this.listener.deliverEvent(new NodeDownEvent(conn.getPeer(), failed, cause));
        } else {
            logger.warn("ConnectionDown with no context available: " + conn);
        }
    }

    @Override
    protected void onOutboundConnectionFailed(Connection<AckosMessage<T>> conn, Throwable cause) {
        if (this.establishedConnections.containsKey(conn.getPeer())) {
            throw new RuntimeException("Context exists in conn failed");
        }
        Pair<Connection<AckosMessage<T>>, Queue<T>> remove = this.pendingConnections.remove(conn.getPeer());
        if (remove != null) {
            LinkedList failed = new LinkedList((Collection)remove.getRight());
            this.listener.deliverEvent(new NodeDownEvent(conn.getPeer(), failed, cause));
        } else {
            logger.warn("ConnectionFailed with no pending: " + conn);
        }
    }

    private void handleAckMessage(AckosAckMessage<T> msg, Connection<AckosMessage<T>> conn) {
        if (conn.isInbound()) {
            throw new RuntimeException("Received AckMessage in inbound connection");
        }
        OutConnectionContext<T> context = this.establishedConnections.get(conn.getPeer());
        if (context == null) {
            throw new RuntimeException("Received AckMessage without an established connection");
        }
        T ackMsg = context.ack(msg.getId());
        this.listener.messageSent(ackMsg, conn.getPeer());
    }

    private void handleAppMessage(AckosAppMessage<T> msg, Connection<AckosMessage<T>> conn) {
        if (conn.isOutbound()) {
            throw new RuntimeException("Received AppMessage in outbound connection");
        }
        conn.sendMessage(new AckosAckMessage(msg.getId()));
        this.listener.deliverMessage(msg.getPayload(), conn.getPeer());
    }

    @Override
    protected void onInboundConnectionUp(Connection<AckosMessage<T>> con) {
        logger.debug("Inbound up: " + con);
    }

    @Override
    protected void onInboundConnectionDown(Connection<AckosMessage<T>> con, Throwable cause) {
        logger.debug("Inbound down: " + con + " ... " + cause);
    }

    @Override
    public void onServerSocketBind(boolean success, Throwable cause) {
        if (success) {
            logger.debug("Server socket ready");
        } else {
            logger.error("Server socket bind failed: " + cause);
        }
    }

    @Override
    public void onServerSocketClose(boolean success, Throwable cause) {
        logger.debug("Server socket closed. " + (success ? "" : "Cause: " + cause));
    }

    @Override
    public void onDeliverMessage(AckosMessage<T> msg, Connection<AckosMessage<T>> conn) {
        switch (msg.getType()) {
            case ACK: {
                this.handleAckMessage((AckosAckMessage)msg, conn);
                break;
            }
            case APP_MSG: {
                this.handleAppMessage((AckosAppMessage)msg, conn);
            }
        }
    }

    @Override
    protected void onOpenConnection(Host peer) {
        throw new NotImplementedException("Pls fix me");
    }

    @Override
    public boolean validateAttributes(Attributes attr) {
        Short channel = attr.getShort("magic_number");
        return channel != null && channel == 17669;
    }

    static {
        ACKOS_ATTRIBUTES.putShort("magic_number", (short)17669);
    }
}

