/*
 * Decompiled with CFR 0.152.
 */
package pt.unl.fct.di.novasys.channel.ackos;

import io.netty.util.concurrent.Promise;
import java.util.LinkedList;
import java.util.Queue;
import org.apache.commons.lang3.tuple.Pair;
import pt.unl.fct.di.novasys.channel.ackos.messaging.AckosAppMessage;
import pt.unl.fct.di.novasys.channel.ackos.messaging.AckosMessage;
import pt.unl.fct.di.novasys.network.Connection;

class OutConnectionContext<T> {
    private final Connection<AckosMessage<T>> connection;
    private final Queue<Pair<Long, T>> pending;
    private long counter;

    OutConnectionContext(Connection<AckosMessage<T>> connection) {
        this.connection = connection;
        this.pending = new LinkedList<Pair<Long, T>>();
        this.counter = 0L;
    }

    Connection<AckosMessage<T>> getConnection() {
        return this.connection;
    }

    Queue<Pair<Long, T>> getPending() {
        return this.pending;
    }

    void sendMessage(T msg, Promise<Void> p) {
        this.pending.add(Pair.of((Object)(++this.counter), msg));
        this.connection.sendMessage(new AckosAppMessage<T>(this.counter, msg), p);
    }

    T ack(long id) {
        Pair<Long, T> poll = this.pending.poll();
        if (poll == null || (Long)poll.getKey() != id) {
            throw new RuntimeException("Ack out of order: " + id + " " + poll);
        }
        return (T)poll.getValue();
    }
}

