/*
 * Decompiled with CFR 0.152.
 */
package pt.unl.fct.di.novasys.network.messaging.control;

import io.netty.buffer.ByteBuf;
import pt.unl.fct.di.novasys.network.messaging.control.ControlMessage;

public class InvalidAttributesMessage
extends ControlMessage {
    public final int magicNumber;
    static ControlMessage.ControlMessageSerializer serializer = new ControlMessage.ControlMessageSerializer<InvalidAttributesMessage>(){

        @Override
        public void serialize(InvalidAttributesMessage msg, ByteBuf out) {
            out.writeInt(msg.magicNumber);
        }

        @Override
        public InvalidAttributesMessage deserialize(ByteBuf in) {
            int magicNumber = in.readInt();
            if (magicNumber != 2036819058) {
                throw new RuntimeException("Invalid magic number: " + magicNumber);
            }
            return new InvalidAttributesMessage(magicNumber);
        }
    };

    public InvalidAttributesMessage() {
        this(2036819058);
    }

    public InvalidAttributesMessage(int magicNumber) {
        super(ControlMessage.Type.INVALID_ATTR);
        this.magicNumber = magicNumber;
    }

    public String toString() {
        return "InvalidAttributesMessage{magicNumber=" + this.magicNumber + '}';
    }
}

