/*
 * Decompiled with CFR 0.152.
 */
package pt.unl.fct.di.novasys.network.pipeline;

import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.EventLoop;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.concurrent.Promise;
import io.netty.util.concurrent.PromiseNotifier;
import java.net.InetSocketAddress;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import pt.unl.fct.di.novasys.network.data.Attributes;
import pt.unl.fct.di.novasys.network.data.Host;
import pt.unl.fct.di.novasys.network.listeners.InConnListener;
import pt.unl.fct.di.novasys.network.listeners.MessageListener;
import pt.unl.fct.di.novasys.network.messaging.NetworkMessage;
import pt.unl.fct.di.novasys.network.pipeline.ConnectionHandler;
import pt.unl.fct.di.novasys.network.pipeline.MessageDecoder;
import pt.unl.fct.di.novasys.network.pipeline.MessageEncoder;
import pt.unl.fct.di.novasys.network.userevents.HandshakeCompleted;

public class InConnectionHandler<T>
extends ConnectionHandler<T> {
    private static final Logger logger = LogManager.getLogger(InConnectionHandler.class);
    private boolean outsideUp;
    private final InConnListener<T> listener;

    public InConnectionHandler(InConnListener<T> listener, MessageListener<T> consumer, EventLoop loop, Attributes selfAttrs, MessageEncoder<T> encoder, MessageDecoder<T> decoder) {
        super(consumer, loop, true, selfAttrs);
        this.encoder = encoder;
        this.decoder = decoder;
        this.listener = listener;
        this.outsideUp = false;
    }

    public void channelActive(ChannelHandlerContext ctx) {
        logger.debug("Incoming channel active: " + ctx.channel().remoteAddress());
        this.channel = ctx.channel();
        InetSocketAddress addr = (InetSocketAddress)ctx.channel().remoteAddress();
        this.peer = new Host(addr.getAddress(), addr.getPort());
    }

    @Override
    public void sendMessage(T msg, Promise<Void> promise) {
        this.loop.execute(() -> {
            ChannelFuture future = this.channel.writeAndFlush((Object)new NetworkMessage(1, msg));
            if (promise != null) {
                future.addListener((GenericFutureListener)new PromiseNotifier(new Promise[]{promise}));
            }
        });
    }

    @Override
    public void sendMessage(T msg) {
        this.sendMessage(msg, null);
    }

    @Override
    public void disconnect() {
        this.loop.execute(() -> {
            this.channel.flush();
            this.channel.close();
        });
    }

    @Override
    public void internalUserEventTriggered(ChannelHandlerContext ctx, Object evt) {
        if (evt instanceof HandshakeCompleted) {
            this.peerAttributes = ((HandshakeCompleted)evt).getAttr();
            this.listener.inboundConnectionUp(this);
            this.outsideUp = true;
        } else {
            logger.warn("Unknown user event caught: " + evt);
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        logger.debug("In connection exception: " + ctx.channel().remoteAddress().toString() + " " + cause);
        if (this.outsideUp) {
            this.listener.inboundConnectionDown(this, cause);
            this.outsideUp = false;
        }
        ctx.close();
    }

    public void channelInactive(ChannelHandlerContext ctx) {
        logger.debug("In connection closed: " + ctx.channel().remoteAddress().toString());
        if (this.outsideUp) {
            this.listener.inboundConnectionDown(this, null);
            this.outsideUp = false;
        }
    }

    public String toString() {
        return "InConnectionHandler{peer=" + this.peer + ", attributes=" + this.peerAttributes + ", channel=" + this.channel + '}';
    }
}

