/*
 * Decompiled with CFR 0.152.
 */
package pt.unl.fct.di.novasys.network.pipeline;

import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.util.concurrent.GenericFutureListener;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import pt.unl.fct.di.novasys.network.AttributeValidator;
import pt.unl.fct.di.novasys.network.data.Attributes;
import pt.unl.fct.di.novasys.network.messaging.NetworkMessage;
import pt.unl.fct.di.novasys.network.messaging.control.ControlMessage;
import pt.unl.fct.di.novasys.network.messaging.control.FirstHandshakeMessage;
import pt.unl.fct.di.novasys.network.messaging.control.InvalidAttributesMessage;
import pt.unl.fct.di.novasys.network.messaging.control.SecondHandshakeMessage;
import pt.unl.fct.di.novasys.network.userevents.HandshakeCompleted;

public class InHandshakeHandler
extends ChannelDuplexHandler {
    private static final Logger logger = LogManager.getLogger(InHandshakeHandler.class);
    private final AttributeValidator validator;
    private final Attributes myAttrs;

    public InHandshakeHandler(AttributeValidator validator, Attributes myAttrs) {
        this.validator = validator;
        this.myAttrs = myAttrs;
    }

    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) {
        ctx.write(msg, promise.addListener((GenericFutureListener)ChannelFutureListener.FIRE_EXCEPTION_ON_FAILURE));
    }

    public void channelRead(ChannelHandlerContext ctx, Object obj) throws Exception {
        FirstHandshakeMessage fhm;
        NetworkMessage msg = (NetworkMessage)obj;
        if (msg.code != 0) {
            throw new Exception("Received application message in inHandshake: " + msg);
        }
        ControlMessage cMsg = (ControlMessage)msg.payload;
        if (cMsg.type == ControlMessage.Type.HEARTBEAT) {
            return;
        }
        if (cMsg.type == ControlMessage.Type.FIRST_HS) {
            fhm = (FirstHandshakeMessage)cMsg;
            if (!this.validator.validateAttributes(fhm.attributes)) {
                ctx.channel().writeAndFlush((Object)new NetworkMessage(0, new InvalidAttributesMessage()));
                throw new Exception("Invalid attributes received");
            }
        } else {
            throw new Exception("Received unexpected control message in inHandshake: " + msg);
        }
        ctx.channel().writeAndFlush((Object)new NetworkMessage(0, new SecondHandshakeMessage(this.myAttrs)));
        ctx.fireUserEventTriggered((Object)new HandshakeCompleted(fhm.attributes));
        ctx.pipeline().remove((ChannelHandler)this);
    }
}

