/*
 * Decompiled with CFR 0.152.
 */
package pt.unl.fct.di.novasys.network.pipeline;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.EventLoop;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.timeout.IdleStateHandler;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.concurrent.Promise;
import io.netty.util.concurrent.PromiseNotifier;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import pt.unl.fct.di.novasys.network.ISerializer;
import pt.unl.fct.di.novasys.network.data.Attributes;
import pt.unl.fct.di.novasys.network.data.Host;
import pt.unl.fct.di.novasys.network.listeners.MessageListener;
import pt.unl.fct.di.novasys.network.listeners.OutConnListener;
import pt.unl.fct.di.novasys.network.messaging.NetworkMessage;
import pt.unl.fct.di.novasys.network.pipeline.ConnectionHandler;
import pt.unl.fct.di.novasys.network.pipeline.MessageDecoder;
import pt.unl.fct.di.novasys.network.pipeline.MessageEncoder;
import pt.unl.fct.di.novasys.network.pipeline.OutHandshakeHandler;
import pt.unl.fct.di.novasys.network.userevents.HandshakeCompleted;

public class OutConnectionHandler<T>
extends ConnectionHandler<T>
implements GenericFutureListener<ChannelFuture> {
    private static final Logger logger = LogManager.getLogger(OutConnectionHandler.class);
    private final Bootstrap clientBootstrap;
    private final OutConnListener<T> listener;
    private State state;

    public OutConnectionHandler(Host peer, Bootstrap bootstrap, OutConnListener<T> listener, MessageListener<T> consumer, ISerializer<T> serializer, EventLoop loop, final Attributes selfAttrs, final int hbInterval, final int hbTolerance) {
        super(consumer, loop, false, selfAttrs);
        this.peer = peer;
        this.listener = listener;
        this.state = State.CONNECTING;
        this.channel = null;
        this.clientBootstrap = bootstrap.clone();
        this.clientBootstrap.remoteAddress(peer.getAddress(), peer.getPort());
        this.encoder = new MessageEncoder<T>(serializer);
        this.decoder = new MessageDecoder<T>(serializer);
        this.clientBootstrap.handler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            protected void initChannel(SocketChannel ch) {
                if (hbTolerance > 0 || hbInterval > 0) {
                    ch.pipeline().addLast("IdleHandler", (ChannelHandler)new IdleStateHandler((long)hbTolerance, (long)hbInterval, 0L, TimeUnit.MILLISECONDS));
                }
                ch.pipeline().addLast("MessageDecoder", (ChannelHandler)OutConnectionHandler.this.decoder);
                ch.pipeline().addLast("MessageEncoder", (ChannelHandler)OutConnectionHandler.this.encoder);
                ch.pipeline().addLast("OutHandshakeHandler", (ChannelHandler)new OutHandshakeHandler(selfAttrs));
                ch.pipeline().addLast("OutCon", (ChannelHandler)OutConnectionHandler.this);
            }
        });
        this.clientBootstrap.group((EventLoopGroup)loop);
        this.connect();
    }

    private void connect() {
        this.loop.execute(() -> {
            if (this.channel != null && this.channel.isOpen()) {
                throw new AssertionError((Object)("Channel open in connect: " + this.peer));
            }
            logger.debug("Connecting to " + this.peer);
            this.channel = this.clientBootstrap.connect().addListener((GenericFutureListener)this).channel();
        });
    }

    public void channelActive(ChannelHandlerContext ctx) {
        if (this.state != State.CONNECTING || ctx.channel() != this.channel) {
            throw new AssertionError((Object)("Channel active without being in disconnected state: " + this.peer));
        }
        this.state = State.HANDSHAKING;
    }

    @Override
    public void sendMessage(T msg, Promise<Void> promise) {
        this.loop.execute(() -> {
            if (this.state == State.CONNECTED) {
                logger.debug("Writing " + msg + " to outChannel of " + this.peer);
                ChannelFuture future = this.channel.writeAndFlush((Object)new NetworkMessage(1, msg));
                if (promise != null) {
                    future.addListener((GenericFutureListener)new PromiseNotifier(new Promise[]{promise}));
                }
            } else {
                logger.warn("Writing message " + msg + " to channel " + this.peer + " in unprepared state " + (Object)((Object)this.state));
            }
        });
    }

    @Override
    public void sendMessage(T msg) {
        this.sendMessage(msg, null);
    }

    @Override
    public void disconnect() {
        this.loop.execute(() -> {
            if (this.state == State.DEAD) {
                return;
            }
            logger.debug("Disconnecting channel to: " + this.peer + ", status was " + (Object)((Object)this.state));
            this.channel.flush();
            this.channel.close();
        });
    }

    @Override
    public void internalUserEventTriggered(ChannelHandlerContext ctx, Object evt) {
        if (evt instanceof HandshakeCompleted) {
            if (this.state != State.HANDSHAKING || ctx.channel() != this.channel) {
                throw new AssertionError((Object)("Handshake completed while not in handshake state: " + this.peer));
            }
            this.state = State.CONNECTED;
            this.peerAttributes = ((HandshakeCompleted)evt).getAttr();
            logger.debug("Handshake completed to: " + this.peer);
            this.listener.outboundConnectionUp(this);
        } else {
            logger.warn("Unknown user event caught: " + evt);
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        if (this.state == State.DEAD) {
            return;
        }
        logger.debug("Out connection exception: " + this.peer + " " + cause);
        switch (this.state) {
            case CONNECTED: {
                this.listener.outboundConnectionDown(this, cause);
                break;
            }
            case HANDSHAKING: 
            case CONNECTING: {
                this.listener.outboundConnectionFailed(this, cause);
                break;
            }
            default: {
                throw new AssertionError((Object)("State is " + (Object)((Object)this.state) + " in exception caught closed callback"));
            }
        }
        this.state = State.DEAD;
        if (ctx.channel().isOpen()) {
            ctx.close();
        }
    }

    public void operationComplete(ChannelFuture future) {
        if (!future.isSuccess()) {
            logger.debug("Connecting failed: " + future.cause());
            if (this.state != State.CONNECTING) {
                throw new AssertionError((Object)("State is " + (Object)((Object)this.state) + " in connecting callback"));
            }
            this.listener.outboundConnectionFailed(this, future.cause());
            this.state = State.DEAD;
        }
    }

    public void channelInactive(ChannelHandlerContext ctx) {
        if (this.state == State.DEAD) {
            return;
        }
        logger.debug("Connection closed: " + this.peer);
        switch (this.state) {
            case CONNECTED: {
                this.listener.outboundConnectionDown(this, null);
                break;
            }
            case HANDSHAKING: {
                this.listener.outboundConnectionFailed(this, null);
                break;
            }
            default: {
                throw new AssertionError((Object)("State is " + (Object)((Object)this.state) + " in connection closed callback"));
            }
        }
        this.state = State.DEAD;
    }

    public String toString() {
        return "OutConnectionHandler{peer=" + this.peer + ", attributes=" + this.peerAttributes + ", channel=" + this.channel + '}';
    }

    static enum State {
        CONNECTING,
        HANDSHAKING,
        CONNECTED,
        DEAD;

    }
}

