/*
 * Decompiled with CFR 0.152.
 */
package org.lsmp.djep.sjep;

import org.lsmp.djep.sjep.Monomial;
import org.lsmp.djep.sjep.PConstant;
import org.lsmp.djep.sjep.PNodeI;
import org.lsmp.djep.sjep.Polynomial;
import org.lsmp.djep.sjep.PolynomialCreator;
import org.nfunk.jep.ParseException;

public class MutiablePolynomial {
    PolynomialCreator pc;
    PNodeI[] terms;

    public MutiablePolynomial(PolynomialCreator pc, PNodeI[] nodes) {
        this.pc = pc;
        this.terms = nodes;
    }

    public void add(PNodeI term) throws ParseException {
        int i;
        if (term instanceof PConstant) {
            for (i = 0; i < this.terms.length; ++i) {
                if (!(this.terms[i] instanceof PConstant)) continue;
                this.terms[i] = this.terms[i].add(term);
                return;
            }
        }
        if (term instanceof Polynomial) {
            Polynomial p = (Polynomial)term;
            for (int i2 = 0; i2 < p.terms.length; ++i2) {
                this.add(p.terms[i2]);
            }
            return;
        }
        for (i = 0; i < this.terms.length; ++i) {
            if (this.terms[i] instanceof Monomial) {
                if (!((Monomial)this.terms[i]).equalsIgnoreConstant(term)) continue;
                this.terms[i] = this.terms[i].add(term);
                return;
            }
            if (!this.terms[i].equals(term)) continue;
            this.terms[i] = this.terms[i].add(term);
            return;
        }
        PNodeI[] newTerms = new PNodeI[this.terms.length + 1];
        int pos = 0;
        boolean done = false;
        for (int i3 = 0; i3 < this.terms.length; ++i3) {
            if (!done && this.terms[i3].compareTo(term) > 0) {
                newTerms[pos] = term;
                ++pos;
                done = true;
            }
            newTerms[pos] = this.terms[i3];
            ++pos;
        }
        if (!done) {
            newTerms[pos] = term;
            ++pos;
        }
        this.terms = newTerms;
    }

    void expandMul(Polynomial p) throws ParseException {
        PNodeI[][] newTerms = new PNodeI[this.terms.length][p.terms.length];
        for (int i = 0; i < this.terms.length; ++i) {
            for (int j = 0; j < p.terms.length; ++j) {
                newTerms[i][j] = this.terms[i].mul(p.terms[j]);
            }
        }
        int oldLen = this.terms.length;
        this.terms = new PNodeI[0];
        for (int i = 0; i < oldLen; ++i) {
            for (int j = 0; j < p.terms.length; ++j) {
                this.add(newTerms[i][j]);
            }
        }
    }

    void expandMul(PNodeI node) throws ParseException {
        int i;
        if (node instanceof Polynomial) {
            this.expandMul((Polynomial)node);
            return;
        }
        PNodeI[] newTerms = new PNodeI[this.terms.length];
        for (i = 0; i < this.terms.length; ++i) {
            newTerms[i] = this.terms[i].mul(node);
        }
        this.terms = new PNodeI[0];
        for (i = 0; i < newTerms.length; ++i) {
            this.add(newTerms[i]);
        }
    }

    private void reduce() throws ParseException {
        int numZeros = 0;
        int numConst = 0;
        PConstant c = this.pc.zeroConstant;
        for (int i = 0; i < this.terms.length; ++i) {
            if (this.terms[i].isZero()) {
                ++numZeros;
                continue;
            }
            if (!(this.terms[i] instanceof PConstant)) continue;
            ++numConst;
            c = (PConstant)c.add(this.terms[i]);
        }
        if (numZeros == 0 && numConst == 0) {
            return;
        }
        int newLen = this.terms.length - numZeros - numConst;
        if (!c.isZero()) {
            ++newLen;
        }
        PNodeI[] newTerms = new PNodeI[newLen];
        int pos = 0;
        if (!c.isZero()) {
            newTerms[pos++] = c;
        }
        for (int i = 0; i < this.terms.length; ++i) {
            if (this.terms[i].isZero() || this.terms[i] instanceof PConstant) continue;
            newTerms[pos] = this.terms[i];
            ++pos;
        }
        this.terms = newTerms;
    }

    PNodeI toPNode() throws ParseException {
        this.reduce();
        if (this.terms.length == 0) {
            return this.pc.zeroConstant;
        }
        if (this.terms.length == 1) {
            return this.terms[0];
        }
        return new Polynomial(this.pc, this.terms);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this.terms.length; ++i) {
            if (i > 0) {
                sb.append('+');
            }
            sb.append(this.terms[i].toString());
        }
        return sb.toString();
    }
}

