/*
 * Decompiled with CFR 0.152.
 */
package peernet;

import java.io.PrintStream;
import peernet.config.Configuration;
import peernet.config.IllegalParameterException;
import peernet.config.MissingParameterException;
import peernet.config.ParsedProperties;
import peernet.core.CommonState;
import peernet.core.Engine;
import peernet.dynamics.BootstrapServer;

public class Simulator {
    public static final int EDSIM = 1;
    public static final int UNKNOWN = -1;
    protected static final String[] simName = new String[]{"peersim.cdsim.CDSimulator", "peersim.edsim.EDSimulator"};
    public static final String PAR_REDIRECT = "simulation.stdout";
    public static final String PAR_SIM_NAME = "simulation.name";

    public static void main(String[] args) {
        long time = System.currentTimeMillis();
        System.err.println("Simulator: loading configuration");
        Configuration.setConfig(new ParsedProperties(args));
        PrintStream newout = (PrintStream)Configuration.getInstance(PAR_REDIRECT, System.out);
        if (newout != System.out) {
            System.setOut(newout);
        }
        CommonState.setExperienceName(Configuration.getString(PAR_SIM_NAME, "Simulation-" + System.currentTimeMillis()));
        if (Engine.getType() == Engine.Type.COORDINATOR) {
            BootstrapServer bootstrapServer = new BootstrapServer();
        } else {
            try {
                System.err.println("Random seed: " + CommonState.r.getLastSeed());
                System.out.println("\n\n");
                Engine engine = Engine.instance();
                engine.startExperiment();
            }
            catch (MissingParameterException e) {
                System.err.println("" + e);
                e.printStackTrace();
                System.exit(1);
            }
            catch (IllegalParameterException e) {
                System.err.println("" + e);
                System.exit(1);
            }
            if (Configuration.contains("__t")) {
                System.out.println(System.currentTimeMillis() - time);
            }
        }
    }
}

