/*
 * Decompiled with CFR 0.152.
 */
package peernet.config;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import org.lsmp.djep.groupJep.GroupJep;
import org.nfunk.jep.JEP;
import org.nfunk.jep.SymbolTable;
import peernet.config.ClassFinder;
import peernet.config.Configuration;
import peernet.config.IllegalParameterException;
import peernet.config.MissingParameterException;
import peernet.config.Operators;

public class ConfigContainer {
    private static final int DEBUG_NO = 0;
    private static final int DEBUG_REG = 1;
    private static final int DEBUG_CONTEXT = 2;
    private Properties config;
    private Map<String, Integer> protocols;
    private int maxdepth;
    private int debugLevel;
    private boolean check = false;

    public ConfigContainer(Properties config, boolean check) {
        this.config = config;
        this.check = check;
        this.maxdepth = this.getInt("expressions.maxdepth", 100);
        this.protocols = new HashMap<String, Integer>();
        String[] prots = this.getNames("protocol");
        int i = 0;
        while (i < prots.length) {
            this.protocols.put(prots[i].substring("protocol".length() + 1), i);
            ++i;
        }
        String debug = config.getProperty("debug.config");
        if ("context".equals(debug)) {
            this.debugLevel = 2;
        } else if ("full".equals(debug)) {
            TreeMap<String, String> map = new TreeMap<String, String>();
            Enumeration<?> e = config.propertyNames();
            while (e.hasMoreElements()) {
                String name = (String)e.nextElement();
                String value = config.getProperty(name);
                map.put(name, value);
            }
            for (String name : map.keySet()) {
                System.err.println("DEBUG " + name + ("".equals(map.get(name)) ? "" : " = " + (String)map.get(name)));
            }
        } else {
            this.debugLevel = debug != null ? 1 : 0;
        }
    }

    public boolean contains(String name) {
        boolean ret = this.config.containsKey(name);
        this.debug(name, "" + ret);
        return ret;
    }

    public boolean getBoolean(String name, boolean def) {
        try {
            return this.getBool(name);
        }
        catch (RuntimeException e) {
            this.manageDefault(name, def, e);
            return def;
        }
    }

    public boolean getBoolean(String name) {
        try {
            return this.getBool(name);
        }
        catch (RuntimeException e) {
            this.manageException(name, e);
            return false;
        }
    }

    private boolean getBool(String name) {
        if (this.config.getProperty(name) == null) {
            throw new MissingParameterException(name);
        }
        if (this.config.getProperty(name).matches("\\p{Blank}*")) {
            throw new MissingParameterException(name, "Blank value is not accepted when parsing Boolean.");
        }
        boolean ret = Boolean.valueOf(this.config.getProperty(name));
        this.debug(name, "" + ret);
        return ret;
    }

    public int getInt(String name, int def) {
        try {
            Number ret = this.getVal(name, name, 0);
            this.debug(name, "" + ret);
            return ret.intValue();
        }
        catch (RuntimeException e) {
            this.manageDefault(name, def, e);
            return def;
        }
    }

    public int getInt(String name) {
        try {
            Number ret = this.getVal(name, name, 0);
            this.debug(name, "" + ret);
            return ret.intValue();
        }
        catch (RuntimeException e) {
            this.manageException(name, e);
            return 0;
        }
    }

    public long getLong(String name, long def) {
        try {
            Number ret = this.getVal(name, name, 0);
            this.debug(name, "" + ret);
            return ret.longValue();
        }
        catch (RuntimeException e) {
            this.manageDefault(name, def, e);
            return def;
        }
    }

    public long getLong(String name) {
        try {
            Number ret = this.getVal(name, name, 0);
            this.debug(name, "" + ret);
            return ret.longValue();
        }
        catch (RuntimeException e) {
            this.manageException(name, e);
            return 0L;
        }
    }

    public double getDouble(String name, double def) {
        try {
            Number ret = this.getVal(name, name, 0);
            this.debug(name, "" + ret);
            return ret.doubleValue();
        }
        catch (RuntimeException e) {
            this.manageDefault(name, def, e);
            return def;
        }
    }

    public double getDouble(String name) {
        try {
            Number ret = this.getVal(name, name, 0);
            this.debug(name, "" + ret);
            return ret.doubleValue();
        }
        catch (RuntimeException e) {
            this.manageException(name, e);
            return 0.0;
        }
    }

    private Number getVal(String initial, String property, int depth) {
        if (depth > this.maxdepth) {
            throw new IllegalParameterException(initial, "Probable recursive definition - exceeded maximum depth " + this.maxdepth);
        }
        String s = this.config.getProperty(property);
        if (s == null || s.equals("")) {
            throw new MissingParameterException(property, " when evaluating property " + initial);
        }
        GroupJep jep = new GroupJep(new Operators());
        jep.setAllowUndeclared(true);
        jep.parseExpression(s);
        String[] symbols = this.getSymbols(jep);
        int i = 0;
        while (i < symbols.length) {
            Number d = this.getVal(initial, symbols[i], depth + 1);
            jep.addVariable(symbols[i], d);
            ++i;
        }
        Object ret = jep.getValueAsObject();
        if (jep.hasError()) {
            System.err.println(jep.getErrorInfo());
        }
        return (Number)ret;
    }

    private String[] getSymbols(JEP jep) {
        SymbolTable h = jep.getSymbolTable();
        String[] ret = new String[h.size()];
        Enumeration e = h.keys();
        int i = 0;
        while (e.hasMoreElements()) {
            ret[i++] = (String)e.nextElement();
        }
        return ret;
    }

    public String getString(String name, String def) {
        try {
            return this.getStr(name);
        }
        catch (RuntimeException e) {
            this.manageDefault(name, def, e);
            return def;
        }
    }

    public String getString(String name) {
        try {
            return this.getStr(name);
        }
        catch (RuntimeException e) {
            this.manageException(name, e);
            return "";
        }
    }

    private String getStr(String name) {
        String result = this.config.getProperty(name);
        if (result == null) {
            throw new MissingParameterException(name);
        }
        this.debug(name, result);
        return result.trim();
    }

    public int getPid(String name) {
        try {
            String protname = this.getStr(name);
            return this.lookupPid(protname);
        }
        catch (RuntimeException e) {
            this.manageException(name, e);
            return 0;
        }
    }

    public int getPid(String name, int pid) {
        try {
            String protname = this.getStr(name);
            return this.lookupPid(protname);
        }
        catch (RuntimeException e) {
            this.manageDefault(name, pid, e);
            return pid;
        }
    }

    public int lookupPid(String protname) {
        Integer ret = this.protocols.get(protname);
        if (ret == null) {
            throw new MissingParameterException("protocol." + protname);
        }
        return ret;
    }

    public String lookupPid(int pid) {
        if (!this.protocols.containsValue(pid)) {
            return null;
        }
        for (Map.Entry<String, Integer> i : this.protocols.entrySet()) {
            if (i.getValue() != pid) continue;
            return i.getKey();
        }
        return null;
    }

    public Class<?> getClass(String name) {
        try {
            return this.getClazz(name);
        }
        catch (RuntimeException e) {
            this.manageException(name, e);
            return null;
        }
    }

    private Class<?> getClazz(String name) {
        String shortname;
        String fullname;
        String[] names;
        String fullname2;
        String classname = this.config.getProperty(name);
        if (classname == null) {
            throw new MissingParameterException(name);
        }
        this.debug(name, classname);
        Class<?> c = null;
        try {
            c = Class.forName(classname);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        if (c == null && (fullname2 = ClassFinder.getQualifiedName(classname)) != null) {
            try {
                c = Class.forName(fullname2);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        if (c == null && (fullname2 = ClassFinder.getQualifiedName(classname)) != null && (names = fullname2.split(",")).length > 1) {
            int i = 0;
            while (i < names.length) {
                int j = i + 1;
                while (j < names.length) {
                    if (names[i].equals(names[j])) {
                        throw new IllegalParameterException(name, "The class " + names[i] + " appears more than once in the classpath; please check" + " your classpath to avoid duplications.");
                    }
                    ++j;
                }
                ++i;
            }
            throw new IllegalParameterException(name, "The non-qualified class name " + classname + "corresponds to multiple fully-qualified classes:" + fullname2);
        }
        if (c == null && (fullname = ClassFinder.getQualifiedName(shortname = ClassFinder.getShortName(classname))) != null) {
            throw new IllegalParameterException(name, "Class " + classname + " does not exist. Possible candidate(s): " + fullname);
        }
        if (c == null) {
            throw new IllegalParameterException(name, "Class " + classname + " not found");
        }
        return c;
    }

    public Class<?> getClass(String name, Class<?> def) {
        try {
            return Configuration.getClass(name);
        }
        catch (RuntimeException e) {
            this.manageDefault(name, def, e);
            return def;
        }
    }

    public Object getInstance(String name) {
        try {
            return this.getInst(name);
        }
        catch (RuntimeException e) {
            this.manageException(name, e);
            return null;
        }
    }

    private Object getInst(String name) {
        Class<?> c = this.getClass(name);
        if (c == null) {
            return null;
        }
        String classname = c.getSimpleName();
        try {
            Class[] pars = new Class[]{String.class};
            Constructor<?> cons = c.getConstructor(pars);
            Object[] objpars = new Object[]{name};
            return cons.newInstance(objpars);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalParameterException(name, "Class " + classname + " has no " + classname + "(String) constructor");
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() instanceof RuntimeException) {
                throw (RuntimeException)e.getTargetException();
            }
            e.getTargetException().printStackTrace();
            throw new RuntimeException("" + e.getTargetException());
        }
        catch (Exception e) {
            throw new IllegalParameterException(name, "" + e);
        }
    }

    public Object getInstance(String name, Object def) {
        try {
            return this.getInst(name);
        }
        catch (RuntimeException e) {
            this.manageDefault(name, def, e);
            return def;
        }
    }

    public Object[] getInstanceArray(String name) {
        String[] names = this.getNames(name);
        Object[] result = new Object[names.length];
        int i = 0;
        while (i < names.length) {
            result[i] = this.getInstance(names[i]);
            ++i;
        }
        return result;
    }

    public String[] getNames(String name) {
        ArrayList<String> ll = new ArrayList<String>();
        String pref = String.valueOf(name) + ".";
        Enumeration<?> e = this.config.propertyNames();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            if (!key.startsWith(pref) || key.indexOf(".", pref.length()) >= 0) continue;
            ll.add(key);
        }
        String[] ret = ll.toArray(new String[ll.size()]);
        return this.order(ret, name);
    }

    private String[] order(String[] names, String type) {
        boolean include;
        String order = this.getString("include." + type, null);
        boolean bl = include = order != null;
        if (!include) {
            order = this.getString("order." + type, null);
        }
        int i = 0;
        if (order != null && !order.equals("")) {
            String[] sret = order.split("\\W+");
            while (i < sret.length) {
                int j = i;
                while (j < names.length) {
                    if (names[j].equals(String.valueOf(type) + "." + sret[i])) break;
                    ++j;
                }
                if (j == names.length) {
                    throw new IllegalParameterException(String.valueOf(include ? "include" : "order") + "." + type, String.valueOf(type) + "." + sret[i] + " is not defined.");
                }
                String tmps = names[j];
                names[j] = names[i];
                names[i] = tmps;
                ++i;
            }
        }
        Arrays.sort(names, i, names.length);
        int retsize = include ? i : names.length;
        String[] ret = new String[retsize];
        int j = 0;
        while (j < retsize) {
            ret[j] = names[j];
            ++j;
        }
        return ret;
    }

    /*
     * Unable to fully structure code
     */
    private void debug(String name, String result) {
        if (this.debugLevel == 0) {
            return;
        }
        buffer = new StringBuffer();
        buffer.append("DEBUG ");
        buffer.append(name);
        buffer.append(" = ");
        buffer.append(result);
        if (this.debugLevel == 2) {
            buffer.append("\n  at ");
            stack = null;
            try {
                throw new Exception();
            }
            catch (Exception e) {
                stack = e.getStackTrace();
                pos = 0;
                ** while (pos < stack.length)
            }
lbl-1000:
            // 1 sources

            {
                if (!stack[pos].getClassName().equals(Configuration.class.getName())) break;
                ++pos;
                continue;
            }
lbl25:
            // 2 sources

            buffer.append(stack[pos].getClassName());
            buffer.append(":");
            buffer.append(stack[pos].getLineNumber());
            buffer.append(", method ");
            buffer.append(stack[pos - 1].getMethodName());
            buffer.append("()");
        }
        System.err.println(buffer);
    }

    private String[] letterPairs(String str) {
        int numPairs = str.length() - 1;
        String[] pairs = new String[numPairs];
        int i = 0;
        while (i < numPairs) {
            pairs[i] = str.substring(i, i + 2);
            ++i;
        }
        return pairs;
    }

    private ArrayList<String> wordLetterPairs(String str) {
        ArrayList<String> allPairs = new ArrayList<String>();
        String[] words = str.split("\\s");
        int w = 0;
        while (w < words.length) {
            String[] pairsInWord = this.letterPairs(words[w]);
            int p = 0;
            while (p < pairsInWord.length) {
                allPairs.add(pairsInWord[p]);
                ++p;
            }
            ++w;
        }
        return allPairs;
    }

    private double compareStrings(String str1, String str2) {
        ArrayList<String> pairs1 = this.wordLetterPairs(str1.toUpperCase());
        ArrayList<String> pairs2 = this.wordLetterPairs(str2.toUpperCase());
        int intersection = 0;
        int union_ = pairs1.size() + pairs2.size();
        int i = 0;
        while (i < pairs1.size()) {
            String pair1 = pairs1.get(i);
            int j = 0;
            while (j < pairs2.size()) {
                String pair2 = pairs2.get(j);
                if (pair1.equals(pair2)) {
                    ++intersection;
                    pairs2.remove(j);
                    break;
                }
                ++j;
            }
            ++i;
        }
        return 2.0 * (double)intersection / (double)union_;
    }

    private String getSimilarProperty(String property) {
        String bestProperty = null;
        double bestValue = 0.0;
        Enumeration<Object> e = this.config.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            double compare = this.compareStrings(key, property);
            if (!(compare > bestValue)) continue;
            bestValue = compare;
            bestProperty = key;
        }
        return bestProperty;
    }

    private void manageDefault(String name, Object def, RuntimeException e) {
        this.debug(name, def + " (DEFAULT)");
        if (this.check) {
            System.out.println("Warning: Property " + name + " = " + def + " (DEFAULT)");
        }
        if (!(e instanceof MissingParameterException)) {
            if (e instanceof IllegalParameterException) {
                System.out.println("Error: " + ((IllegalParameterException)e).getShortMessage());
            } else {
                System.out.println("Error: " + name + " " + e);
                e.printStackTrace();
            }
        }
    }

    private void manageException(String name, RuntimeException e) {
        if (this.check) {
            if (e instanceof MissingParameterException) {
                System.out.println("Error: " + ((MissingParameterException)e).getShortMessage());
            } else if (e instanceof IllegalParameterException) {
                System.out.println("Error: " + ((IllegalParameterException)e).getShortMessage());
            } else {
                System.out.println("Error: " + e.getMessage());
            }
        } else {
            throw e;
        }
    }
}

