/*
 * Decompiled with CFR 0.152.
 */
package peernet.config;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import peernet.config.ConfigProperties;

public class ParsedProperties
extends ConfigProperties {
    public ParsedProperties(String[] pars) {
        super(pars);
    }

    public ParsedProperties(String filename) throws IOException {
        super(filename);
    }

    @Override
    public void load(String fileName) throws IOException {
        HashSet prefixes = new HashSet();
        BufferedReader f = new BufferedReader(new FileReader(fileName));
        int lines = 0;
        this.parseStream(f, "", 0, lines, prefixes);
        f.close();
    }

    private int parseStream(BufferedReader f, String prefix, int pars, int lines, Set prefixes) throws IOException {
        String part;
        if (prefix.equals(".")) {
            System.err.println("Error at line " + lines + ": bracket block not " + "associated with any configuration entry");
            System.exit(1);
        }
        if (prefixes.contains(prefix)) {
            System.err.println("Error at line " + lines + ": multiple bracket " + "blocks referring to the same configuration entry " + prefix);
            System.exit(1);
        } else {
            prefixes.add(prefix);
        }
        boolean complete = true;
        String line = "";
        String last = "";
        while ((part = f.readLine()) != null) {
            int index;
            ++lines;
            if (complete) {
                line = "";
            }
            if ((index = part.indexOf(35)) >= 0) {
                part = part.substring(0, index);
            }
            if ("".equals(part = part.trim())) continue;
            boolean bl = complete = part.charAt(part.length() - 1) != '\\';
            if (!complete) {
                line = String.valueOf(line) + part.substring(0, part.length() - 2) + " ";
                continue;
            }
            if ((line = String.valueOf(line) + part).equals("{")) {
                lines = this.parseStream(f, String.valueOf(last) + ".", pars + 1, lines, prefixes);
                continue;
            }
            if (line.equals("}")) {
                if (pars == 0) {
                    System.err.println("Error: Additional } at line " + lines + " when parsing the configuration file");
                    System.exit(1);
                }
                return lines;
            }
            String[] tokens = line.split("[\\s:=]+", 2);
            if (tokens.length == 1) {
                this.setProperty(String.valueOf(prefix) + tokens[0], "");
            } else {
                this.setProperty(String.valueOf(prefix) + tokens[0], tokens[1]);
            }
            last = String.valueOf(prefix) + tokens[0];
        }
        if (pars == 1) {
            System.err.println("Error: One closing bracket ('}') is missing");
            System.exit(1);
        } else if (pars > 1) {
            System.err.println("Error: " + pars + " closing brackets ('}') are missing");
            System.exit(1);
        }
        return lines;
    }
}

