/*
 * Decompiled with CFR 0.152.
 */
package peernet.core;

import java.util.Arrays;
import peernet.config.Configuration;
import peernet.config.IllegalParameterException;
import peernet.core.CommonState;
import peernet.core.Control;
import peernet.core.EngineNet;
import peernet.core.EngineSim;
import peernet.core.Network;
import peernet.core.Node;
import peernet.core.Schedule;
import peernet.dynamics.NodeInitializer;
import peernet.transport.Address;

public abstract class Engine {
    private static final String PREFIX = "engine";
    private static final String PAR_DURATION = "duration";
    private static final String PAR_LOGTIME = "logtime";
    private static final String PAR_RBITS = "timebits";
    private static final String PAR_INIT = "init";
    private static final String PAR_CONTROL = "control";
    private static final String PAR_PROTOCOL = "protocol";
    private static final String PAR_SCHEDULE = "schedule";
    private static final String PAR_MODE = "mode";
    static long endtime;
    protected static long logtime;
    static int rbits;
    static Control[] controls;
    protected static Schedule[] controlSchedules;
    protected static Schedule[][] protocolSchedules;
    protected static long nextlog;
    private static Engine instance;
    private static final Type type;
    private static final AddressType addressType;

    static {
        controls = null;
        controlSchedules = null;
        protocolSchedules = null;
        nextlog = 0L;
        instance = null;
        String typeStr = Configuration.getString("engine.mode", "");
        if (typeStr.equals("sim")) {
            type = Type.SIM;
            addressType = AddressType.SIM;
        } else if (typeStr.equals("emu")) {
            type = Type.EMU;
            addressType = AddressType.SIM;
        } else if (typeStr.equals("net")) {
            type = Type.NET;
            addressType = AddressType.NET;
        } else if (typeStr.equals("coordinator")) {
            type = Type.COORDINATOR;
            addressType = null;
        } else {
            throw new IllegalParameterException("engine.mode", "Possible types: sim, emu, net, coordinator");
        }
    }

    public static Type getType() {
        return type;
    }

    public static AddressType getAddressType() {
        return addressType;
    }

    private void runInitializers() {
        Object[] inits = Configuration.getInstanceArray(PAR_INIT);
        String[] names = Configuration.getNames(PAR_INIT);
        int i = 0;
        while (i < inits.length) {
            System.err.println("- Running initializer " + names[i] + ": " + inits[i].getClass());
            ((Control)inits[i]).execute();
            ++i;
        }
    }

    private void scheduleControls() {
        String[] names = Configuration.getNames(PAR_CONTROL);
        controls = new Control[names.length];
        controlSchedules = new Schedule[names.length];
        int i = 0;
        while (i < names.length) {
            Engine.controls[i] = (Control)Configuration.getInstance(names[i]);
            Engine.controlSchedules[i] = new Schedule(names[i]);
            ++i;
        }
        System.err.println("Engine: loaded controls " + Arrays.asList(names));
        boolean order = false;
        int i2 = 0;
        while (i2 < controls.length) {
            if (i2 > 127) {
                throw new IllegalArgumentException("Too many control objects");
            }
            long delay = controlSchedules[i2].initialDelay();
            if (delay >= 0L) {
                this.addEventIn(delay, null, null, i2, null);
            }
            ++i2;
        }
    }

    private void scheduleProtocols(Node node) {
        int pid = 0;
        Schedule[][] scheduleArray = protocolSchedules;
        int n = protocolSchedules.length;
        int n2 = 0;
        while (n2 < n) {
            Schedule[] schedList;
            Schedule[] scheduleArray2 = schedList = scheduleArray[n2];
            int n3 = schedList.length;
            int n4 = 0;
            while (n4 < n3) {
                Schedule sched = scheduleArray2[n4];
                long delay = sched.initialDelay();
                if (delay >= 0L) {
                    this.addEventIn(delay, null, node, pid, sched);
                }
                ++n4;
            }
            ++pid;
            ++n2;
        }
    }

    private void scheduleProtocols() {
        String[] protocolNames = Configuration.getNames(PAR_PROTOCOL);
        protocolSchedules = new Schedule[protocolNames.length][];
        int i = 0;
        while (i < protocolNames.length) {
            String[] scheduleNames = Configuration.getNames(String.valueOf(protocolNames[i]) + "." + PAR_SCHEDULE);
            Engine.protocolSchedules[i] = new Schedule[scheduleNames.length + 1];
            Engine.protocolSchedules[i][0] = new Schedule(protocolNames[i]);
            Engine.protocolSchedules[i][0].schedId = 0;
            int j = 0;
            while (j < scheduleNames.length) {
                String strSchedId = Configuration.suffix(scheduleNames[j]);
                if (!strSchedId.matches("^[0-9]+$")) {
                    throw new IllegalParameterException(scheduleNames[j], "Schedule identifiers have to be numeric. E.g., try " + protocolNames[i] + "." + PAR_SCHEDULE + ".1");
                }
                int schedId = Integer.valueOf(strSchedId);
                if (schedId <= 0) {
                    throw new IllegalParameterException(scheduleNames[j], "Schedule identifiers have to be greater than zero. E.g., try " + protocolNames[i] + "." + PAR_SCHEDULE + ".1");
                }
                Engine.protocolSchedules[i][j + 1] = new Schedule(scheduleNames[j]);
                Engine.protocolSchedules[i][j + 1].schedId = schedId;
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < Network.size()) {
            Node node = Network.get(i);
            this.scheduleProtocols(node);
            ++i;
        }
    }

    protected abstract void createHeaps();

    void addEventIn(long delay, Address src, Node node, int pid, Object event) {
        if (delay < 0L) {
            System.err.println("Event with negative delay: " + delay);
        }
        long nextTime = CommonState.getTime() + delay;
        this.addEventAt(nextTime, src, node, pid, event);
    }

    abstract void addEventAt(long var1, Address var3, Node var4, int var5, Object var6);

    abstract int pendingEvents();

    public abstract void blockingInitializerStart();

    public abstract void blockingInitializerDone();

    public void startExperiment() {
        System.err.println("Engine: starting experiment in " + (Object)((Object)Engine.getType()) + " mode");
        rbits = Configuration.getInt("engine.timebits", 8);
        if (rbits < 8 || rbits >= 64) {
            throw new IllegalParameterException("engine.timebits", "This parameter should be >= 8 or < 64");
        }
        endtime = Configuration.getLong("engine.duration", Long.MAX_VALUE);
        CommonState.setEndTime(endtime);
        logtime = Configuration.getLong("engine.logtime", Long.MAX_VALUE);
        nextlog = 0L;
        System.err.println("Engine: resetting");
        Network.reset();
        this.createHeaps();
        this.runInitializers();
        this.scheduleControls();
        this.scheduleProtocols();
    }

    public static Engine instance() {
        if (instance == null) {
            switch (Engine.getType()) {
                case SIM: {
                    instance = new EngineSim();
                    break;
                }
                case EMU: {
                    instance = new EngineNet();
                    break;
                }
                case NET: {
                    instance = new EngineNet();
                    break;
                }
                default: {
                    throw new IllegalParameterException("engine.mode", Configuration.getString("engine.mode"));
                }
            }
        }
        return instance;
    }

    public Node addNode(NodeInitializer[] inits) {
        Node n = Network.addNode();
        int i = 0;
        while (i < inits.length) {
            inits[i].initialize(n);
            ++i;
        }
        this.scheduleProtocols(n);
        return n;
    }

    public static enum AddressType {
        SIM,
        NET;

    }

    public static enum Type {
        SIM,
        EMU,
        NET,
        COORDINATOR;

    }
}

