/*
 * Decompiled with CFR 0.152.
 */
package peernet.core;

import peernet.core.CommonState;
import peernet.core.Engine;
import peernet.core.Event;
import peernet.core.Heap;
import peernet.core.Network;
import peernet.core.Node;
import peernet.core.Protocol;
import peernet.core.Schedule;
import peernet.dynamics.BootstrapClient;
import peernet.dynamics.BootstrapServer;
import peernet.transport.Address;
import peernet.transport.Packet;
import peernet.transport.TransportNet;
import peernet.util.CountLatch;

public class EngineNet
extends Engine {
    Heap controlHeap = null;
    private CountLatch blockingInitializers = new CountLatch(0);

    @Override
    protected void createHeaps() {
        int n = 0;
        while (n < Network.size()) {
            Network.get(n).setHeap(new Heap());
            ++n;
        }
        this.controlHeap = new Heap();
    }

    @Override
    public void startExperiment() {
        Node node;
        int n;
        super.startExperiment();
        if (EngineNet.getType() == Engine.Type.NET) {
            n = 0;
            while (n < Network.size()) {
                node = Network.get(n);
                int j = 0;
                while (j < node.getTransports()) {
                    new ListeningThread(node, node.getHeap(), (TransportNet)node.getTransport(j)).start();
                    ++j;
                }
                ++n;
            }
        }
        this.blockingInitializers.await();
        CommonState.timeStartsNow();
        n = 0;
        while (n < Network.size()) {
            node = Network.get(n);
            new ExecutionThread(node.getHeap()).start();
            ++n;
        }
        new ExecutionThread(this.controlHeap).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addEventAt(long time, Address src, Node node, int pid, Object event) {
        if (time >= endtime) {
            return;
        }
        time = time << rbits | (long)CommonState.r.nextInt(1 << rbits);
        Heap heap = null;
        heap = node == null ? this.controlHeap : node.getHeap();
        Heap heap2 = heap;
        synchronized (heap2) {
            heap.add(time, src, node, (byte)pid, event);
            heap.notify();
        }
    }

    @Override
    public int pendingEvents() {
        int events = 0;
        int n = 0;
        while (n < Network.size()) {
            events += Network.get(n).getHeap().size();
            ++n;
        }
        return events;
    }

    protected boolean executeNext(Event ev) {
        long time = ev.time >> rbits;
        if (time >= endtime) {
            return true;
        }
        byte pid = ev.pid;
        if (ev.node == null) {
            int n = 0;
            while (n < Network.size()) {
                Network.get(n).acquireLock();
                ++n;
            }
            boolean ret = controls[pid].execute();
            int n2 = 0;
            while (n2 < Network.size()) {
                Network.get(n2).releaseLock();
                ++n2;
            }
            long delay = controlSchedules[pid].nextDelay(time);
            if (delay >= 0L) {
                this.addEventAt(time + delay, null, null, pid, null);
            }
            return ret;
        }
        if (ev.node.isUp()) {
            Protocol prot = ev.node.getProtocol(pid);
            if (ev.event instanceof Schedule) {
                ev.node.acquireLock();
                prot.nextCycle(((Schedule)ev.event).schedId);
                ev.node.releaseLock();
                long delay = prot.nextDelay();
                if (delay == 0L) {
                    delay = ((Schedule)ev.event).nextDelay(time);
                }
                if (delay > 0L) {
                    this.addEventAt(time + delay, null, ev.node, pid, ev.event);
                }
            } else {
                ev.node.acquireLock();
                prot.processEvent(ev.src, ev.event);
                ev.node.releaseLock();
            }
        }
        return false;
    }

    @Override
    public void blockingInitializerStart() {
        this.blockingInitializers.countUp();
    }

    @Override
    public void blockingInitializerDone() {
        this.blockingInitializers.countDown();
    }

    public class ExecutionThread
    extends Thread {
        private Heap heap = null;

        public ExecutionThread(Heap heap) {
            this.heap = heap;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            boolean exit = false;
            while (!exit) {
                Event event;
                block9: {
                    event = null;
                    Heap heap = this.heap;
                    synchronized (heap) {
                        while (true) {
                            while (true) {
                                long remainingTime;
                                if ((remainingTime = (this.heap.getNextTime() >> rbits) - CommonState.getTime()) <= 0L) {
                                    event = this.heap.removeFirst();
                                    break block9;
                                }
                                try {
                                    this.heap.wait(remainingTime);
                                }
                                catch (InterruptedException e) {
                                    e.printStackTrace();
                                }
                            }
                            break;
                        }
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                    }
                }
                exit = EngineNet.this.executeNext(event);
            }
        }

        @Override
        public Object clone() {
            return new Heap();
        }
    }

    public class ListeningThread
    extends Thread {
        Node node = null;
        Heap heap = null;
        TransportNet transport = null;

        public ListeningThread(Node node, Heap heap, TransportNet transport) {
            this.node = node;
            this.heap = heap;
            this.transport = transport;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (true) {
                Packet packet = this.transport.receive();
                assert (packet != null) : "packet is null!";
                assert (packet.src != null) : "packet.src is null!";
                assert (packet.event != null) : "packet.event is null!";
                if (packet.event instanceof BootstrapServer.BootstrapMessage) {
                    BootstrapClient.report(this.node, (BootstrapServer.BootstrapMessage)packet.event);
                    continue;
                }
                Heap heap = this.heap;
                synchronized (heap) {
                    this.heap.add(0L, packet.src, this.node, (byte)packet.pid, packet.event);
                    this.heap.notify();
                }
            }
        }
    }
}

