/*
 * Decompiled with CFR 0.152.
 */
package peernet.core;

import peernet.core.CommonState;
import peernet.core.Engine;
import peernet.core.Event;
import peernet.core.Heap;
import peernet.core.Node;
import peernet.core.Protocol;
import peernet.core.Schedule;
import peernet.transport.Address;

public class EngineSim
extends Engine {
    Heap simHeap = null;

    @Override
    public void startExperiment() {
        super.startExperiment();
        boolean exit = false;
        while (!exit) {
            exit = this.executeNext(this.simHeap);
        }
        int j = 0;
        while (j < controls.length) {
            if (EngineSim.controlSchedules[j].fin) {
                controls[j].execute();
            }
            ++j;
        }
    }

    private boolean executeNext(Heap heap) {
        Event ev = heap.removeFirst();
        if (ev == null) {
            System.err.println("Engine: queue is empty, quitting at time " + CommonState.getTime());
            return true;
        }
        long time = ev.time >> rbits;
        if (time >= nextlog) {
            System.err.println("Current time: " + time);
            while (time >= (nextlog += logtime)) {
            }
        }
        if (time >= endtime) {
            System.err.println("Engine: reached end time, quitting, leaving " + heap.size() + " unprocessed events in the queue");
            return true;
        }
        CommonState.setTime(time);
        byte pid = ev.pid;
        if (ev.node == null) {
            boolean ret = controls[pid].execute();
            long delay = controlSchedules[pid].nextDelay(time);
            if (delay >= 0L) {
                this.addEventIn(delay, null, null, pid, null);
            }
            return ret;
        }
        if (ev.node.isUp()) {
            if (ev.event instanceof Schedule) {
                Protocol prot = ev.node.getProtocol(pid);
                prot.nextCycle(((Schedule)ev.event).schedId);
                long delay = prot.nextDelay();
                if (delay == 0L) {
                    delay = ((Schedule)ev.event).nextDelay(time);
                }
                if (delay > 0L) {
                    this.addEventIn(delay, null, ev.node, pid, ev.event);
                }
            } else {
                Protocol prot = ev.node.getProtocol(pid);
                prot.processEvent(ev.src, ev.event);
            }
        }
        return false;
    }

    @Override
    public void addEventAt(long time, Address src, Node node, int pid, Object event) {
        time = time << rbits | (long)CommonState.r.nextInt(1 << rbits);
        this.simHeap.add(time, src, node, (byte)pid, event);
    }

    @Override
    protected void createHeaps() {
        this.simHeap = new Heap();
    }

    @Override
    public int pendingEvents() {
        return this.simHeap.size();
    }

    @Override
    public void blockingInitializerStart() {
        throw new RuntimeException("Blocking initializers not applicable to SIM mode");
    }

    @Override
    public void blockingInitializerDone() {
        throw new RuntimeException("Blocking initializers not applicable to SIM mode");
    }
}

