/*
 * Decompiled with CFR 0.152.
 */
package peernet.core;

import java.util.Arrays;
import java.util.PriorityQueue;
import java.util.Random;
import peernet.core.Event;
import peernet.core.EventQueue;
import peernet.core.Node;
import peernet.transport.Address;

class Heap
implements EventQueue {
    private static final int SIZE = 1;
    private Object[] events;
    private long[] times;
    private Node[] nodes;
    private byte[] pids;
    private Address[] srcs;
    private int size;
    private final Event ev = new Event();

    public Heap() {
        this(1);
    }

    public Heap(int size) {
        this.events = new Object[size];
        this.times = new long[size];
        this.nodes = new Node[size];
        this.pids = new byte[size];
        this.srcs = new Address[size];
    }

    public int size() {
        return this.size;
    }

    @Override
    public void add(long time, Address src, Node node, byte pid, Object event) {
        ++this.size;
        int pos = this.size;
        this.put(pos, time, src, node, pid, event);
        while (pos > 1 && this.getTime(pos / 2) > time) {
            this.swap(pos, pos / 2);
            pos /= 2;
        }
    }

    @Override
    public Event removeFirst() {
        if (this.size == 0) {
            return null;
        }
        this.ev.time = this.times[0];
        this.ev.event = this.events[0];
        this.ev.node = this.nodes[0];
        this.ev.pid = this.pids[0];
        this.ev.src = this.srcs[0];
        this.swap(1, this.size);
        --this.size;
        this.minHeapify(1);
        return this.ev;
    }

    @Override
    public long getNextTime() {
        if (this.size() == 0) {
            return Long.MAX_VALUE;
        }
        return this.times[0];
    }

    @Override
    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[Size: " + this.size + " Times: ");
        int i = 1;
        while (i <= this.size) {
            buffer.append(String.valueOf(this.getTime(i)) + ",");
            ++i;
        }
        buffer.append("]");
        return buffer.toString();
    }

    private void minHeapify(int index) {
        long time = this.getTime(index);
        int minindex = index;
        do {
            long rt;
            long lt;
            index = minindex;
            long mintime = time;
            int l = index << 1;
            int r = l + 1;
            if (l <= this.size && (lt = this.getTime(l)) < mintime) {
                minindex = l;
                mintime = lt;
            }
            if (r <= this.size && (rt = this.getTime(r)) < mintime) {
                minindex = r;
                mintime = rt;
            }
            if (minindex == index) continue;
            this.swap(minindex, index);
        } while (minindex != index);
    }

    private void swap(int i1, int i2) {
        long tt = this.times[--i1];
        this.times[i1] = this.times[--i2];
        this.times[i2] = tt;
        Address ts = this.srcs[i1];
        this.srcs[i1] = this.srcs[i2];
        this.srcs[i2] = ts;
        Node tn = this.nodes[i1];
        this.nodes[i1] = this.nodes[i2];
        this.nodes[i2] = tn;
        byte tp = this.pids[i1];
        this.pids[i1] = this.pids[i2];
        this.pids[i2] = tp;
        Object te = this.events[i1];
        this.events[i1] = this.events[i2];
        this.events[i2] = te;
    }

    private long getTime(int index) {
        return this.times[--index];
    }

    private void put(int index, long time, Address src, Node node, byte pid, Object event) {
        if (--index >= this.events.length) {
            this.doubleCapacity();
        }
        this.times[index] = time;
        this.nodes[index] = node;
        this.srcs[index] = src;
        this.pids[index] = pid;
        this.events[index] = event;
    }

    private void doubleCapacity() {
        int oldsize = this.events.length;
        int newsize = oldsize * 2;
        long[] tt = new long[newsize];
        System.arraycopy(this.times, 0, tt, 0, oldsize);
        this.times = tt;
        Address[] ts = new Address[newsize];
        System.arraycopy(this.srcs, 0, ts, 0, oldsize);
        this.srcs = ts;
        Node[] tn = new Node[newsize];
        System.arraycopy(this.nodes, 0, tn, 0, oldsize);
        this.nodes = tn;
        byte[] tp = new byte[newsize];
        System.arraycopy(this.pids, 0, tp, 0, oldsize);
        this.pids = tp;
        Object[] te = new Object[newsize];
        System.arraycopy(this.events, 0, te, 0, oldsize);
        this.events = te;
    }

    public static void main(String[] args) {
        Random random = new Random();
        Heap heap = new Heap();
        int rep = Integer.MAX_VALUE;
        if (args.length > 0) {
            rep = Integer.parseInt(args[0]);
        }
        System.err.println("Attempting to use: " + rep);
        long[] values1 = new long[rep];
        long[] values2 = new long[rep];
        long[] values3 = new long[rep];
        int i = 0;
        while (i < rep) {
            values1[i] = random.nextInt(1000000000);
            ++i;
        }
        long time1 = System.currentTimeMillis();
        int i2 = 0;
        while (i2 < rep) {
            heap.add(values1[i2], null, null, (byte)1, null);
            ++i2;
        }
        long time2 = System.currentTimeMillis();
        System.out.println("Inserting: " + (time2 - time1));
        time1 = System.currentTimeMillis();
        int i3 = 0;
        while (i3 < rep) {
            values2[i3] = heap.removeFirst().time;
            ++i3;
        }
        time2 = System.currentTimeMillis();
        System.out.println("Removing: " + (time2 - time1));
        Event ev = new Event();
        PriorityQueue<Event> pq = new PriorityQueue<Event>();
        time1 = System.currentTimeMillis();
        int i4 = 0;
        while (i4 < rep) {
            ev.time = values1[i4];
            pq.add(ev);
            ++i4;
        }
        time2 = System.currentTimeMillis();
        System.out.println("PQ Inserting: " + (time2 - time1));
        time1 = System.currentTimeMillis();
        i4 = 0;
        while (i4 < rep) {
            values3[i4] = ((Event)pq.remove()).time;
            ++i4;
        }
        time2 = System.currentTimeMillis();
        System.out.println("PQ Removing: " + (time2 - time1));
        Arrays.sort(values1);
        System.out.println("Done!");
    }
}

