/*
 * Decompiled with CFR 0.152.
 */
package peernet.core;

import java.util.Vector;
import java.util.concurrent.Semaphore;
import peernet.config.Configuration;
import peernet.core.Cleanable;
import peernet.core.Engine;
import peernet.core.Fallible;
import peernet.core.Heap;
import peernet.core.Protocol;
import peernet.transport.Transport;

public class Node
implements Fallible,
Cloneable {
    private static final String PAR_PROTOCOL = "protocol";
    private static final String PAR_TRANSPORT = "transport";
    private static long counterID = -1L;
    protected Protocol[] protocols = null;
    private Transport[] transports = null;
    private int[] mappingProtTrans = null;
    private int index;
    protected int failstate = 0;
    private long ID;
    private Heap heap;
    private Semaphore semaphore;

    public Protocol getProtocol(int i) {
        return this.protocols[i];
    }

    public final long getID() {
        return this.ID;
    }

    public final void setID(long id) {
        this.ID = id;
    }

    public Node(String prefix) {
        String[] protNames = Configuration.getNames(PAR_PROTOCOL);
        this.ID = this.nextID();
        this.protocols = new Protocol[protNames.length];
        this.mappingProtTrans = new int[protNames.length];
        Vector<String> transportNames = new Vector<String>();
        int i = 0;
        while (i < protNames.length) {
            String transportName = Configuration.getString(String.valueOf(protNames[i]) + "." + PAR_TRANSPORT, null);
            if (!transportNames.contains(transportName)) {
                transportNames.add(transportName);
            }
            int j = transportNames.indexOf(transportName);
            assert (j >= 0);
            this.mappingProtTrans[i] = j;
            ++i;
        }
        this.transports = new Transport[transportNames.size()];
        i = 0;
        while (i < this.transports.length) {
            this.transports[i] = transportNames.get(i) == null ? Transport.defaultTransportInstance() : (Transport)Configuration.getInstance("transport." + (String)transportNames.get(i));
            ++i;
        }
        i = 0;
        while (i < protNames.length) {
            Protocol p;
            this.protocols[i] = p = (Protocol)Configuration.getInstance(protNames[i]);
            ++i;
        }
    }

    public Object clone() {
        Node node = null;
        try {
            node = (Node)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        node.protocols = (Protocol[])this.protocols.clone();
        node.ID = this.nextID();
        int i = 0;
        while (i < this.protocols.length) {
            node.protocols[i] = (Protocol)this.protocols[i].clone();
            node.protocols[i].node = node;
            ++i;
        }
        node.transports = (Transport[])this.transports.clone();
        i = 0;
        while (i < this.transports.length) {
            node.transports[i] = (Transport)this.transports[i].clone();
            ++i;
        }
        if (Engine.getType() == Engine.Type.NET || Engine.getType() == Engine.Type.EMU) {
            node.semaphore = new Semaphore(1);
        }
        return node;
    }

    public int protocolSize() {
        return this.protocols.length;
    }

    void setIndex(int index) {
        this.index = index;
    }

    public int getIndex() {
        return this.index;
    }

    protected long nextID() {
        return counterID++;
    }

    public int getTransports() {
        return this.transports.length;
    }

    public Transport getTransportByPid(int pid) {
        return this.transports[this.mappingProtTrans[pid]];
    }

    public Transport getTransport(int i) {
        return this.transports[i];
    }

    @Override
    public void setFailState(int failState) {
        if (this.failstate == 1 && failState != 1) {
            throw new IllegalStateException("Cannot change fail state: node is already DEAD");
        }
        switch (failState) {
            case 0: {
                this.failstate = 0;
                break;
            }
            case 1: {
                this.index = -1;
                this.failstate = 1;
                int i = 0;
                while (i < this.protocols.length) {
                    if (this.protocols[i] instanceof Cleanable) {
                        ((Cleanable)((Object)this.protocols[i])).onKill();
                    }
                    ++i;
                }
                break;
            }
            case 2: {
                this.failstate = 2;
                break;
            }
            default: {
                throw new IllegalArgumentException("failState=" + failState);
            }
        }
    }

    @Override
    public int getFailState() {
        return this.failstate;
    }

    @Override
    public boolean isUp() {
        return this.failstate == 0;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("ID: " + this.ID + " index: " + this.index + "\n");
        int i = 0;
        while (i < this.protocols.length) {
            buffer.append("protocol[" + i + "]=" + this.protocols[i] + "\n");
            ++i;
        }
        return buffer.toString();
    }

    public int hashCode() {
        return (int)this.getID();
    }

    public void setHeap(Heap heap) {
        this.heap = heap;
    }

    public Heap getHeap() {
        return this.heap;
    }

    public void acquireLock() {
        try {
            this.semaphore.acquire();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            System.exit(-1);
        }
    }

    public void releaseLock() {
        this.semaphore.release();
    }

    private String defaultTransportName() {
        String transportName = Engine.getType().toString().toLowerCase();
        if (Configuration.contains("transport." + transportName)) {
            return Configuration.getString(transportName);
        }
        return null;
    }
}

