/*
 * Decompiled with CFR 0.152.
 */
package peernet.core;

import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import peernet.core.Engine;
import peernet.core.Node;
import peernet.transport.Address;
import peernet.transport.AddressNet;
import peernet.transport.AddressSim;
import peernet.transport.TransportUDP;

public class Peer
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    public static InetAddress localhost;
    public Address address;
    public long ID;

    static {
        try {
            localhost = InetAddress.getLocalHost();
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
    }

    public Peer(Node node, int pid) {
        this.address = Engine.getAddressType() == Engine.AddressType.NET ? new AddressNet(localhost, ((TransportUDP)node.getTransport(0)).getPort()) : new AddressSim(node);
        this.ID = node.getID();
    }

    public Peer(Address address, long ID) {
        this.address = address;
        this.ID = ID;
    }

    public long getID() {
        return this.ID;
    }

    public boolean equals(Object otherPeer) {
        return this.address.equals(((Peer)otherPeer).address);
    }

    public int hashCode() {
        return this.address.hashCode();
    }

    public Object clone() {
        Peer peer = null;
        try {
            peer = (Peer)super.clone();
        }
        catch (CloneNotSupportedException e) {
            System.out.println(e);
        }
        peer.address = (Address)this.address.clone();
        return peer;
    }

    public Object shalowClone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            return this;
        }
    }
}

