/*
 * Decompiled with CFR 0.152.
 */
package peernet.core;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import peernet.config.Configuration;
import peernet.core.Engine;
import peernet.core.Node;
import peernet.core.Peer;
import peernet.core.ProtocolSettings;
import peernet.transport.Address;

public abstract class Protocol
implements Cloneable {
    public static final String PAR_SETTINGS = "settings";
    protected ProtocolSettings settings;
    Node node;

    public Protocol(String prefix) {
        this.settings = Configuration.contains(String.valueOf(prefix) + "." + PAR_SETTINGS) ? (ProtocolSettings)Configuration.getInstance(String.valueOf(prefix) + "." + PAR_SETTINGS) : new ProtocolSettings(String.valueOf(prefix) + "." + PAR_SETTINGS);
    }

    public Node myNode() {
        return this.node;
    }

    public int myPid() {
        return this.settings.pid;
    }

    public abstract void nextCycle(int var1);

    public abstract void processEvent(Address var1, Object var2);

    public final void schedule(long delay, Object event) {
        Engine.instance().addEventIn(delay, null, this.node, this.settings.pid, event);
    }

    public long nextDelay() {
        return 0L;
    }

    public void send(Address dest, int pid, Object event) {
        this.node.getTransportByPid(this.settings.getPid()).send(this.node, dest, pid, event);
    }

    public Peer myPeer() {
        Peer p = null;
        Constructor c = this.settings.getPeerConstructor();
        try {
            p = (Peer)c.newInstance(this.node, this.settings.getPid());
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        return p;
    }

    public Object clone() {
        Protocol protocol = null;
        try {
            protocol = (Protocol)super.clone();
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
        return protocol;
    }
}

