/*
 * Decompiled with CFR 0.152.
 */
package peernet.core;

import java.lang.reflect.Constructor;
import peernet.config.Configuration;
import peernet.config.IllegalParameterException;
import peernet.core.Node;
import peernet.core.Peer;

public class ProtocolSettings {
    private static final String PAR_LINKABLE = "linkable";
    private static final String PAR_PROTOCOL = "protocol";
    private static final String PAR_PEER = "peer";
    private final int[] links;
    private final Constructor<Peer> peerConstructor;
    final int pid;

    public ProtocolSettings(String prefix) {
        prefix = prefix.replace(".settings", "");
        String protocolName = prefix.toLowerCase().replace("protocol.", "");
        this.pid = Configuration.lookupPid(protocolName);
        if (Configuration.contains(String.valueOf(prefix) + "." + PAR_LINKABLE)) {
            String str = Configuration.getString(String.valueOf(prefix) + "." + PAR_LINKABLE);
            String[] linkNames = str.split("\\W+");
            this.links = new int[linkNames.length];
            int i = 0;
            while (i < linkNames.length) {
                this.links[i] = Configuration.lookupPid(linkNames[i]);
                ++i;
            }
        } else {
            this.links = new int[0];
        }
        Class cPeer = Configuration.getClass(String.valueOf(prefix) + "." + PAR_PEER);
        Class[] pars = new Class[]{Node.class, Integer.TYPE};
        Constructor constr = null;
        try {
            constr = cPeer.getConstructor(pars);
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        this.peerConstructor = constr;
    }

    int getPid() {
        return this.pid;
    }

    public boolean hasLinkable() {
        return this.numLinkables() > 0;
    }

    public int numLinkables() {
        return this.links.length;
    }

    public int getLinkable(int linkIndex) {
        if (linkIndex >= this.numLinkables()) {
            String[] names = Configuration.getNames(PAR_PROTOCOL);
            throw new IllegalParameterException(names[this.pid], "Protocol " + this.pid + " has no " + PAR_LINKABLE + " parameter with index" + linkIndex);
        }
        return this.links[linkIndex];
    }

    public int getLinkable() {
        return this.getLinkable(0);
    }

    public Constructor getPeerConstructor() {
        return this.peerConstructor;
    }
}

