/*
 * Decompiled with CFR 0.152.
 */
package peernet.core;

import peernet.config.Configuration;
import peernet.config.IllegalParameterException;
import peernet.core.CommonState;

public class Schedule {
    public static final String PAR_STEP = "step";
    public static final String PAR_AT = "at";
    public static final String PAR_FROM = "from";
    public static final String PAR_UNTIL = "until";
    private static final String PAR_FINAL = "final";
    private static final String PAR_RANDOMSTART = "randstart";
    public int schedId;
    public long step;
    public long from;
    public long until;
    public boolean fin;
    public boolean randomStart;
    protected long next;

    public Schedule(String prefix) {
        this.fin = Configuration.contains(String.valueOf(prefix) + "." + PAR_FINAL);
        if (Configuration.contains(String.valueOf(prefix) + "." + PAR_AT)) {
            long at;
            if (Configuration.contains(String.valueOf(prefix) + "." + PAR_FROM) || Configuration.contains(String.valueOf(prefix) + "." + PAR_UNTIL) || Configuration.contains(String.valueOf(prefix) + "." + PAR_STEP)) {
                throw new IllegalParameterException(prefix, "Cannot use \"at\" and \"from\"/\"until\"/\"step\" together");
            }
            this.from = at = Configuration.getLong(String.valueOf(prefix) + "." + PAR_AT);
            this.until = at;
            this.step = 1L;
        } else {
            this.from = Configuration.getLong(String.valueOf(prefix) + "." + PAR_FROM, 0L);
            this.until = Configuration.getLong(String.valueOf(prefix) + "." + PAR_UNTIL, Long.MAX_VALUE);
            this.step = Configuration.getLong(String.valueOf(prefix) + "." + PAR_STEP, -1L);
            this.randomStart = Configuration.contains(String.valueOf(prefix) + "." + PAR_RANDOMSTART);
            if (this.step == -1L) {
                this.step = -1L;
                this.until = -1L;
                this.from = -1L;
                if (Configuration.contains(String.valueOf(prefix) + "." + PAR_FROM) || Configuration.contains(String.valueOf(prefix) + "." + PAR_UNTIL)) {
                    System.err.println("Warning: Control " + prefix + " defines \"" + PAR_FROM + "\"/\"" + PAR_UNTIL + "\" but not \"" + PAR_STEP + "\"");
                }
                if (!this.fin) {
                    System.err.println("Warning: Control " + prefix + " will not execute at all!");
                }
            }
        }
        this.next = this.from;
    }

    public boolean active(long time) {
        if (time < this.from || time > this.until) {
            return false;
        }
        return (time - this.from) % this.step == 0L;
    }

    public long getNext() {
        long ret = this.next;
        this.next += this.step;
        if (this.next >= this.until) {
            ret = -1L;
        }
        return ret;
    }

    long initialDelay() {
        if (this.randomStart) {
            return this.from + CommonState.r.nextLong(this.step);
        }
        return this.from;
    }

    long nextDelay(long time) {
        if (time + this.step <= this.until) {
            return this.step;
        }
        return -1L;
    }
}

