/*
 * Decompiled with CFR 0.152.
 */
package peernet.dynamics;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Random;
import java.util.Timer;
import java.util.TimerTask;
import peernet.config.Configuration;
import peernet.core.CommonState;
import peernet.core.Control;
import peernet.core.Engine;
import peernet.core.Linkable;
import peernet.core.Network;
import peernet.core.Node;
import peernet.core.Peer;
import peernet.core.Protocol;
import peernet.dynamics.BootstrapServer;
import peernet.transport.Address;
import peernet.transport.AddressNet;

public class BootstrapClient
extends TimerTask
implements Control {
    private static final String PAR_SERVER = "host";
    private static final String PAR_PORT = "port";
    private static final String PAR_COORDINATOR = "coordinator";
    private static final String PAR_SEQUENTIAL_ID = "SEQ";
    private static HashMap<String, BootstrapClient> map = new HashMap();
    private int pid;
    private Address address;
    private String coordinatorName;
    private ArrayList<Node> remainingNodes;
    private Timer timer;
    private int seq;
    private int numNodes = -1;
    private HashSet<Long> bootstrappedNodes;

    public BootstrapClient(String prefix) {
        try {
            this.pid = Configuration.getPid(String.valueOf(prefix) + "." + "protocol");
            String serverAddress = Configuration.getString(String.valueOf(prefix) + "." + PAR_SERVER);
            InetAddress ip = InetAddress.getByName(serverAddress);
            int serverPort = Configuration.getInt(String.valueOf(prefix) + "." + PAR_PORT);
            this.address = new AddressNet(ip, serverPort);
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
        this.remainingNodes = new ArrayList();
        this.coordinatorName = Configuration.getString(String.valueOf(prefix) + "." + PAR_COORDINATOR, "");
        this.bootstrappedNodes = new HashSet();
        this.seq = Configuration.getInt(PAR_SEQUENTIAL_ID, -1);
        map.put(this.coordinatorName, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        ArrayList<Node> arrayList = this.remainingNodes;
        synchronized (arrayList) {
            System.out.println("Worker: " + this.seq + "  remaining nodes: " + this.remainingNodes.size());
            Collections.shuffle(this.remainingNodes);
            BootstrapServer.BootstrapMessage msg = new BootstrapServer.BootstrapMessage(BootstrapServer.BootstrapMessage.Type.REQUEST);
            msg.coordinatorName = this.coordinatorName;
            msg.peers = new Peer[1];
            for (Node node : this.remainingNodes) {
                if (node.getID() % 3L == 0L) {
                    try {
                        Thread.sleep(1L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                Protocol prot = node.getProtocol(this.pid);
                msg.peers[0] = prot.myPeer();
                prot.send(this.address, this.pid, msg);
            }
        }
    }

    @Override
    public boolean execute() {
        System.out.println("STARTING BootstrapClient.execute()");
        Engine.instance().blockingInitializerStart();
        this.numNodes = Network.size();
        int n = 0;
        while (n < Network.size()) {
            this.remainingNodes.add(Network.get(n));
            ++n;
        }
        Random r = new Random(System.currentTimeMillis());
        int timeOffset = r.nextInt(2000);
        this.timer = new Timer();
        this.timer.schedule((TimerTask)this, timeOffset, 2000L);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void report(Node node, BootstrapServer.BootstrapMessage msg) {
        BootstrapClient b = map.get(msg.coordinatorName);
        switch (msg.type) {
            case REQUEST: {
                assert (false);
            }
            case REQUEST_ACK: {
                node.setID(msg.nodeId);
                ArrayList<Node> arrayList = b.remainingNodes;
                synchronized (arrayList) {
                    b.remainingNodes.remove(node);
                    if (b.remainingNodes.size() == 0) {
                        b.timer.cancel();
                    }
                    break;
                }
            }
            case RESPONSE: {
                node.setID(msg.nodeId);
                Protocol prot = node.getProtocol(b.pid);
                HashSet<Long> hashSet = b.bootstrappedNodes;
                synchronized (hashSet) {
                    if (!b.bootstrappedNodes.contains(node.getID())) {
                        b.bootstrappedNodes.add(node.getID());
                        node.acquireLock();
                        Peer[] peerArray = msg.peers;
                        int n = msg.peers.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Peer d = peerArray[n2];
                            ((Linkable)((Object)prot)).addNeighbor(d);
                            ++n2;
                        }
                        node.releaseLock();
                        if (b.bootstrappedNodes.size() == b.numNodes) {
                            Engine.instance().blockingInitializerDone();
                        }
                    }
                }
                BootstrapServer.BootstrapMessage ack = new BootstrapServer.BootstrapMessage(BootstrapServer.BootstrapMessage.Type.RESPONSE_ACK);
                ack.coordinatorName = msg.coordinatorName;
                ack.peers = null;
                try {
                    Thread.sleep(CommonState.r.nextInt(1000));
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                prot.send(b.address, b.pid, ack);
                break;
            }
            case RESPONSE_ACK: {
                assert (false);
            }
            default: {
                throw new RuntimeException("Received BootstrapMessage of unknown type: " + (Object)((Object)msg.type));
            }
        }
    }
}

