/*
 * Decompiled with CFR 0.152.
 */
package peernet.dynamics;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Timer;
import java.util.Vector;
import peernet.config.Configuration;
import peernet.core.Peer;
import peernet.dynamics.WireControl;
import peernet.graph.NeighborListGraph;
import peernet.transport.Address;
import peernet.transport.AddressNet;
import peernet.transport.Packet;
import peernet.transport.TransportUDP;

public class BootstrapServer {
    private static final String PAR_PREFIX = "coordinator";
    private static final String PAR_TRANSPORT = "transport";
    private static final String PAR_SIZE = "nodes";
    private static final String PAR_TIMEOUT = "timeout";
    private static final String PAR_INIT = "init";
    private static TransportUDP transport = null;
    static long ID = 0L;
    private HashMap<Address, Long> addressToIdMap = new HashMap();
    private HashMap<String, Coordinator> map = new HashMap();
    AddressNet addr;
    Timer timer;

    public BootstrapServer() {
        transport = new TransportUDP(PAR_TRANSPORT);
        transport = (TransportUDP)transport.clone();
    }

    public void start() {
        new Thread(new NetworkListener()).start();
    }

    protected long assignNodeId(Peer peer) {
        return ID++;
    }

    private void setNodeId(Peer peer) {
        Long assignedId = this.addressToIdMap.get(peer.address);
        if (assignedId == null) {
            assignedId = this.assignNodeId(peer);
            this.addressToIdMap.put(peer.address, assignedId);
        }
        peer.ID = assignedId;
    }

    public static class BootstrapMessage
    implements Serializable {
        private static final long serialVersionUID = 7821791956620397834L;
        public Type type;
        public String coordinatorName;
        public long nodeId;
        public Peer[] peers;

        public BootstrapMessage(Type type) {
            this.type = type;
        }

        public static enum Type {
            REQUEST,
            REQUEST_ACK,
            RESPONSE,
            RESPONSE_ACK;

        }
    }

    private class Coordinator {
        private int numNodes;
        private int timeout;
        private boolean completed;
        private int pid = -1;
        private NeighborListGraph graph;
        private WireControl initializer = null;
        private HashMap<Address, Integer> uninformedNodes;
        private String name;
        private int responsesRound;
        private int acksTotal;
        private int acksRound;

        private Coordinator(String prefix) {
            this.name = prefix.substring(prefix.lastIndexOf(46) + 1);
            this.numNodes = Configuration.getInt(String.valueOf(prefix) + "." + BootstrapServer.PAR_SIZE);
            this.timeout = Configuration.getInt(String.valueOf(prefix) + "." + BootstrapServer.PAR_TIMEOUT, -1);
            this.initializer = (WireControl)Configuration.getInstance(String.valueOf(prefix) + "." + BootstrapServer.PAR_INIT);
            this.graph = new NeighborListGraph(true);
            this.uninformedNodes = new HashMap();
            BootstrapServer.this.timer = new Timer();
        }

        private void printProgress() {
            System.out.print("\r" + BootstrapServer.this.addressToIdMap.size() + "\t" + this.acksTotal + '\t' + this.responsesRound + '\t' + this.acksRound);
        }

        private void process(Address src, int pid, BootstrapMessage msg) {
            switch (msg.type) {
                case REQUEST: {
                    if (this.pid == -1) {
                        this.pid = pid;
                    }
                    assert (this.pid == pid);
                    assert (msg.peers.length == 1);
                    Peer p = msg.peers[0];
                    p.address = src;
                    BootstrapServer.this.setNodeId(p);
                    this.registerNewNode(p);
                    BootstrapMessage ack = new BootstrapMessage(BootstrapMessage.Type.REQUEST_ACK);
                    ack.nodeId = p.getID();
                    ack.peers = null;
                    ack.coordinatorName = msg.coordinatorName;
                    transport.send(null, p.address, pid, ack);
                    break;
                }
                case RESPONSE_ACK: {
                    if (this.uninformedNodes.remove(src) == null) break;
                    ++this.acksTotal;
                    ++this.acksRound;
                    this.printProgress();
                    break;
                }
                case REQUEST_ACK: {
                    assert (false);
                }
                case RESPONSE: {
                    assert (false);
                    break;
                }
            }
        }

        private synchronized void registerNewNode(Peer peer) {
            if (!this.completed && !this.uninformedNodes.containsKey(peer.address)) {
                int index = this.graph.addNode(peer);
                this.uninformedNodes.put(peer.address, index);
                this.printProgress();
                if (!this.completed && this.graph.size() == this.numNodes) {
                    this.completed = true;
                    this.buildTopology();
                }
            }
        }

        private synchronized void buildTopology() {
            this.initializer.setGraph(this.graph);
            this.initializer.execute();
            new Thread(new ResponseSender()).start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void sendResponses() {
            while (true) {
                Vector<Integer> indexes;
                HashMap<Address, Integer> hashMap = this.uninformedNodes;
                synchronized (hashMap) {
                    indexes = new Vector<Integer>(this.uninformedNodes.values());
                }
                System.out.println("\nGoing to send " + indexes.size() + " responses.");
                this.acksRound = 0;
                this.responsesRound = indexes.size();
                for (int index : indexes) {
                    Peer peer = (Peer)this.graph.getNode(index);
                    Collection<Integer> neighbors = this.graph.getNeighbours(index);
                    BootstrapMessage msg = new BootstrapMessage(BootstrapMessage.Type.RESPONSE);
                    msg.coordinatorName = this.name;
                    msg.nodeId = peer.getID();
                    msg.peers = new Peer[neighbors.size()];
                    int j = 0;
                    for (int n : neighbors) {
                        Peer p = (Peer)this.graph.getNode(n);
                        msg.peers[j++] = p;
                    }
                    transport.send(null, peer.address, this.pid, msg);
                }
                try {
                    Thread.sleep(10000L);
                    continue;
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                    continue;
                }
                break;
            }
        }

        private class ResponseSender
        implements Runnable {
            private ResponseSender() {
            }

            @Override
            public void run() {
                Coordinator.this.sendResponses();
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public class NetworkListener
    implements Runnable {
        @Override
        public void run() {
            while (true) {
                Coordinator coordinator;
                Packet packet = transport.receive();
                if (!(packet.event instanceof BootstrapMessage)) continue;
                BootstrapMessage msg = (BootstrapMessage)packet.event;
                if (msg.type != BootstrapMessage.Type.REQUEST && msg.type != BootstrapMessage.Type.RESPONSE_ACK) {
                    System.out.println(" *** Received " + (Object)((Object)msg.type) + " from " + packet.src);
                    continue;
                }
                if (!BootstrapServer.this.map.containsKey(msg.coordinatorName)) {
                    coordinator = new Coordinator("coordinator." + msg.coordinatorName);
                    BootstrapServer.this.map.put(msg.coordinatorName, coordinator);
                    System.out.println("BootstrapServer listening at port " + transport.getPort() + ", waiting for " + coordinator.numNodes + " nodes, or " + coordinator.timeout + " milliseconds.");
                }
                coordinator = BootstrapServer.this.map.get(msg.coordinatorName);
                coordinator.process(packet.src, packet.pid, msg);
            }
        }
    }
}

