/*
 * Decompiled with CFR 0.152.
 */
package peernet.dynamics;

import peernet.config.Configuration;
import peernet.core.CommonState;
import peernet.core.Control;
import peernet.core.Engine;
import peernet.core.Network;
import peernet.dynamics.NodeInitializer;

public class DynamicNetwork
implements Control {
    private static final String PAR_INIT = "init";
    private static final String PAR_SUBST = "substitute";
    private static final String PAR_ADD = "add";
    private static final String PAR_MAX = "maxsize";
    private static final String PAR_MIN = "minsize";
    protected final double add;
    protected final boolean substitute;
    protected final int minsize;
    protected final int maxsize;
    protected final NodeInitializer[] inits;

    protected void add(int k) {
        while (k > 0) {
            Engine.instance().addNode(this.inits);
            --k;
        }
    }

    protected void remove(int n) {
        int i = 0;
        while (i < n) {
            Network.remove(CommonState.r.nextInt(Network.size()));
            ++i;
        }
    }

    public DynamicNetwork(String prefix) {
        this.add = Configuration.getDouble(String.valueOf(prefix) + "." + PAR_ADD);
        this.substitute = Configuration.contains(String.valueOf(prefix) + "." + PAR_SUBST);
        Object[] tmp = Configuration.getInstanceArray(String.valueOf(prefix) + "." + PAR_INIT);
        this.inits = new NodeInitializer[tmp.length];
        int i = 0;
        while (i < tmp.length) {
            this.inits[i] = (NodeInitializer)tmp[i];
            ++i;
        }
        this.maxsize = Configuration.getInt(String.valueOf(prefix) + "." + PAR_MAX, Network.getCapacity());
        this.minsize = Configuration.getInt(String.valueOf(prefix) + "." + PAR_MIN, 0);
    }

    @Override
    public final boolean execute() {
        System.out.println("time is " + CommonState.getTime());
        if (this.add == 0.0) {
            return false;
        }
        if (!this.substitute && (this.maxsize <= Network.size() && this.add > 0.0 || this.minsize >= Network.size() && this.add < 0.0)) {
            return false;
        }
        int toadd = 0;
        int toremove = 0;
        if (this.add > 0.0) {
            toadd = (int)(this.add < 1.0 ? this.add * (double)Network.size() : this.add);
            if (!this.substitute && toadd > this.maxsize - Network.size()) {
                toadd = this.maxsize - Network.size();
            }
            if (this.substitute) {
                toremove = toadd;
            }
        } else if (this.add < 0.0) {
            toremove = (int)(this.add > -1.0 ? -this.add * (double)Network.size() : -this.add);
            if (!this.substitute && toremove > Network.size() - this.minsize) {
                toremove = Network.size() - this.minsize;
            }
            if (this.substitute) {
                toadd = toremove;
            }
        }
        this.remove(toremove);
        this.add(toadd);
        return false;
    }
}

