/*
 * Decompiled with CFR 0.152.
 */
package peernet.dynamics;

import peernet.config.Configuration;
import peernet.core.CommonState;
import peernet.core.Control;
import peernet.core.Engine;
import peernet.core.Network;
import peernet.dynamics.NodeInitializer;

public class OscillatingNetwork
implements Control {
    private static final String PAR_INIT = "init";
    private static final String PAR_MAX = "maxsize";
    private static final String PAR_MIN = "minsize";
    private static final String PAR_PERIOD = "period";
    private final int period;
    private final int minsize;
    private final int maxsize;
    private final NodeInitializer[] inits;

    public OscillatingNetwork(String prefix) {
        this.period = Configuration.getInt(String.valueOf(prefix) + "." + PAR_PERIOD);
        this.maxsize = Configuration.getInt(String.valueOf(prefix) + "." + PAR_MAX, Network.getCapacity());
        this.minsize = Configuration.getInt(String.valueOf(prefix) + "." + PAR_MIN, 0);
        Object[] tmp = Configuration.getInstanceArray(String.valueOf(prefix) + "." + PAR_INIT);
        this.inits = new NodeInitializer[tmp.length];
        int i = 0;
        while (i < tmp.length) {
            this.inits[i] = (NodeInitializer)tmp[i];
            ++i;
        }
    }

    protected void add(int k) {
        while (k > 0) {
            Engine.instance().addNode(this.inits);
            --k;
        }
    }

    protected void remove(int n) {
        int i = 0;
        while (i < n) {
            Network.remove(CommonState.r.nextInt(Network.size()));
            ++i;
        }
    }

    @Override
    public boolean execute() {
        long time = CommonState.getTime();
        int amplitude = (this.maxsize - this.minsize) / 2;
        int newsize = (this.maxsize + this.minsize) / 2 + (int)(Math.sin((double)time / (double)this.period * Math.PI) * (double)amplitude);
        int diff = newsize - Network.size();
        if (diff < 0) {
            this.remove(-diff);
        } else {
            this.add(diff);
        }
        return false;
    }
}

