/*
 * Decompiled with CFR 0.152.
 */
package peernet.dynamics;

import java.lang.reflect.Method;
import java.util.ArrayList;
import peernet.config.Configuration;
import peernet.core.CommonState;
import peernet.dynamics.WireGraph;
import peernet.graph.Graph;

public class WireByMethod
extends WireGraph {
    private static final String PAR_ARG = "arg";
    private static final String PAR_CLASS = "class";
    private static final String PAR_METHOD = "method";
    private final Object[] args;
    private final Method method;

    public WireByMethod(String prefix) {
        super(prefix);
        try {
            Class wire = Configuration.getClass(String.valueOf(prefix) + "." + PAR_CLASS, Class.forName("peersim.graph.GraphFactory"));
            this.method = WireByMethod.getMethod(wire, Configuration.getString(String.valueOf(prefix) + "." + PAR_METHOD, "wire"));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        Class<?>[] argt = this.method.getParameterTypes();
        this.args = new Object[argt.length];
        int i = 1;
        while (i < this.args.length) {
            if (argt[i] == Integer.TYPE) {
                this.args[i] = Configuration.getInt(String.valueOf(prefix) + "." + PAR_ARG + i);
            } else if (argt[i] == Long.TYPE) {
                this.args[i] = Configuration.getLong(String.valueOf(prefix) + "." + PAR_ARG + i);
            } else if (argt[i] == Double.TYPE) {
                this.args[i] = Configuration.getDouble(String.valueOf(prefix) + "." + PAR_ARG + i);
            } else if (i == this.args.length - 1 && argt[i].isInstance(CommonState.r)) {
                this.args[i] = CommonState.r;
            } else {
                throw new RuntimeException("Unexpected error, please report this problem to the peersim team");
            }
            ++i;
        }
    }

    private static Method getMethod(Class cl, String methodName) throws NoSuchMethodException, ClassNotFoundException {
        Method[] methods = cl.getMethods();
        ArrayList<Method> list = new ArrayList<Method>();
        Method[] methodArray = methods;
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            Method m = methodArray[n2];
            if (m.getName().equals(methodName)) {
                list.add(m);
            }
            ++n2;
        }
        if (list.size() == 0) {
            throw new NoSuchMethodException("No method " + methodName + " in class " + cl.getSimpleName());
        }
        if (list.size() > 1) {
            throw new NoSuchMethodException("Multiple methods called " + methodName + " in class " + cl.getSimpleName());
        }
        Class<?> graphClass = Class.forName("peersim.graph.Graph");
        Class<?> randomClass = Class.forName("java.util.Random");
        Method method = (Method)list.get(0);
        Class<?>[] pars = method.getParameterTypes();
        if (pars.length < 1 || !pars[0].isAssignableFrom(graphClass)) {
            throw new NoSuchMethodException(String.valueOf(method.getName()) + " of class " + cl.getSimpleName() + " is not a valid graph wiring method," + " it has to have peersim.graph.Graph as first argument type");
        }
        int i = 1;
        while (i < pars.length) {
            if (!(pars[i] == Integer.TYPE || pars[i] == Long.TYPE || pars[i] == Double.TYPE || i == pars.length - 1 && pars[i].isAssignableFrom(randomClass))) {
                throw new NoSuchMethodException(String.valueOf(method.getName()) + " of class " + cl.getSimpleName() + " is not a valid graph wiring method");
            }
            ++i;
        }
        if (method.toString().indexOf("static") < 0) {
            throw new NoSuchMethodException(String.valueOf(method.getName()) + " of class " + cl.getSimpleName() + " is not a valid graph wiring method; it is not static");
        }
        return method;
    }

    @Override
    public void wire(Graph g) {
        this.args[0] = g;
        try {
            this.method.invoke(null, this.args);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

