/*
 * Decompiled with CFR 0.152.
 */
package peernet.dynamics;

import peernet.config.Configuration;
import peernet.core.CommonState;
import peernet.dynamics.WireGraph;
import peernet.graph.Graph;

public class WireScaleFreeDM
extends WireGraph {
    private static final String PAR_EDGES = "k";
    private final int k;

    public WireScaleFreeDM(String prefix) {
        super(prefix);
        this.k = Configuration.getInt(String.valueOf(prefix) + "." + PAR_EDGES);
    }

    @Override
    public void wire(Graph g) {
        int nodes = g.size();
        int[] links = new int[4 * this.k * nodes];
        int clique = this.k > 3 ? this.k : 3;
        int len = 0;
        int i = 0;
        while (i < clique) {
            int j = 0;
            while (j < clique) {
                if (i != j) {
                    g.setEdge(i, j);
                    g.setEdge(j, i);
                    links[len * 2] = i;
                    links[len * 2 + 1] = j;
                    ++len;
                }
                ++j;
            }
            ++i;
        }
        i = clique;
        while (i < nodes) {
            int l = 0;
            while (l < this.k) {
                int edge = CommonState.r.nextInt(len);
                int m = links[edge * 2];
                int j = links[edge * 2 + 1];
                g.setEdge(i, m);
                g.setEdge(m, i);
                g.setEdge(j, m);
                g.setEdge(m, j);
                links[len * 2] = i;
                links[len * 2 + 1] = m;
                links[++len * 2] = j;
                links[len * 2 + 1] = m;
                ++len;
                ++l;
            }
            ++i;
        }
    }
}

