/*
 * Decompiled with CFR 0.152.
 */
package peernet.graph;

import java.util.ArrayList;
import java.util.BitSet;
import peernet.graph.ConstUndirGraph;
import peernet.graph.Graph;

public class FastUndirGraph
extends ConstUndirGraph {
    private BitSet[] triangle;

    public FastUndirGraph(Graph graph) {
        super(graph);
    }

    @Override
    protected void initGraph() {
        int max = this.g.size();
        this.triangle = new BitSet[max];
        int i = 0;
        while (i < max) {
            this.in[i] = new ArrayList();
            this.triangle[i] = new BitSet(i);
            ++i;
        }
        i = 0;
        while (i < max) {
            for (Integer out : this.g.getNeighbours(i)) {
                int j = out;
                if (!this.g.isEdge(j, i)) {
                    this.in[j].add(i);
                }
                if (i > j) {
                    this.triangle[i].set(j);
                    continue;
                }
                this.triangle[j].set(i);
            }
            ++i;
        }
    }

    @Override
    public boolean isEdge(int i, int j) {
        if (i < j) {
            int ii = i;
            i = j;
            j = ii;
        }
        return this.triangle[i].get(j);
    }
}

