/*
 * Decompiled with CFR 0.152.
 */
package peernet.graph;

import java.util.Random;
import peernet.graph.Graph;

public class GraphFactory {
    private GraphFactory() {
    }

    public static Graph wireRingLattice(Graph g, int k) {
        int n = g.size();
        int pred = k % 2 == 0 ? k / 2 : (k - 1) / 2;
        int succ = k % 2 == 0 ? k / 2 : (k + 1) / 2;
        int i = 0;
        while (i < n) {
            int j = -pred;
            while (j <= succ) {
                if (j != 0) {
                    int v = (i + j + n) % n;
                    g.setEdge(i, v);
                }
                ++j;
            }
            ++i;
        }
        return g;
    }

    public static Graph wireWS(Graph g, int k, double p, Random r) {
        int n = g.size();
        int i = 0;
        while (i < n) {
            int j = -k / 2;
            while (j <= k / 2) {
                if (j != 0) {
                    int newedge = (i + j + n) % n;
                    if (r.nextDouble() < p && (newedge = r.nextInt(n - 1)) >= i) {
                        ++newedge;
                    }
                    g.setEdge(i, newedge);
                }
                ++j;
            }
            ++i;
        }
        return g;
    }

    public static Graph wireKOut(Graph g, int k, Random r) {
        int n = g.size();
        if (n < 2) {
            return g;
        }
        if (n <= k) {
            k = n - 1;
        }
        int[] nodes = new int[n];
        int i = 0;
        while (i < nodes.length) {
            nodes[i] = i;
            ++i;
        }
        i = 0;
        while (i < n) {
            int j = 0;
            while (j < k) {
                int newedge = j + r.nextInt(n - j);
                int tmp = nodes[j];
                nodes[j] = nodes[newedge];
                nodes[newedge] = tmp;
                if (nodes[j] == i) continue;
                g.setEdge(i, nodes[j]);
                ++j;
            }
            ++i;
        }
        return g;
    }

    public static Graph wireStar(Graph g) {
        int n = g.size();
        int i = 1;
        while (i < n) {
            g.setEdge(i, 0);
            ++i;
        }
        return g;
    }

    public static Graph wireRegRootedTree(Graph g, int k) {
        if (k == 0) {
            return g;
        }
        int n = g.size();
        int i = 0;
        int j = 1;
        while (j < n) {
            int l = 0;
            while (l < k && j < n) {
                g.setEdge(i, j);
                ++l;
                ++j;
            }
            ++i;
        }
        return g;
    }

    public static Graph wireHypercube(Graph g) {
        int n = g.size();
        if (n <= 1) {
            return g;
        }
        int highestone = Integer.highestOneBit(n - 1);
        int i = 0;
        while (i < n) {
            int mask = highestone;
            while (mask > 0) {
                int j = i ^ mask;
                if (j < n) {
                    g.setEdge(i, j);
                }
                mask >>= 1;
            }
            ++i;
        }
        return g;
    }

    public static Graph wireScaleFreeBA(Graph g, int k, Random r) {
        int nodes = g.size();
        if (nodes <= k) {
            return g;
        }
        int[] ends = new int[2 * k * (nodes - k)];
        int i = 0;
        while (i < k) {
            g.setEdge(k, i);
            ends[2 * i] = k;
            ends[2 * i + 1] = i;
            ++i;
        }
        int len = 2 * k;
        int i2 = k + 1;
        while (i2 < nodes) {
            int j = 0;
            while (j < k) {
                int target;
                int m;
                do {
                    target = ends[r.nextInt(len)];
                    m = 0;
                    while (m < j && ends[len + 2 * m + 1] != target) {
                        ++m;
                    }
                } while (m != j);
                g.setEdge(i2, target);
                ends[len + 2 * j] = i2;
                ends[len + 2 * j + 1] = target;
                ++j;
            }
            len += 2 * k;
            ++i2;
        }
        return g;
    }
}

