/*
 * Decompiled with CFR 0.152.
 */
package peernet.graph;

import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.BitSet;
import java.util.Iterator;
import peernet.graph.Graph;
import peernet.graph.NeighborListGraph;

public class GraphIO {
    private GraphIO() {
    }

    public static void writeEdgeList(Graph g, PrintStream out) {
        int i = 0;
        while (i < g.size()) {
            Iterator<Integer> it = g.getNeighbours(i).iterator();
            while (it.hasNext()) {
                out.println(String.valueOf(i) + " " + it.next());
            }
            ++i;
        }
    }

    public static void writeNeighborList(Graph g, PrintStream out) {
        out.println("# " + g.size());
        int i = 0;
        while (i < g.size()) {
            out.print(String.valueOf(i) + " ");
            Iterator<Integer> it = g.getNeighbours(i).iterator();
            while (it.hasNext()) {
                out.print(it.next() + " ");
            }
            out.println();
            ++i;
        }
    }

    public static void writeGML(Graph g, PrintStream out) {
        out.println("graph [ directed " + (g.directed() ? "1" : "0"));
        int i = 0;
        while (i < g.size()) {
            out.println("node [ id " + i + " ]");
            ++i;
        }
        i = 0;
        while (i < g.size()) {
            Iterator<Integer> it = g.getNeighbours(i).iterator();
            while (it.hasNext()) {
                out.println("edge [ source " + i + " target " + it.next() + " ]");
            }
            ++i;
        }
        out.println("]");
    }

    public static void writeNetmeter(Graph g, PrintStream out) {
        out.println("*Vertices " + g.size());
        int i = 0;
        while (i < g.size()) {
            out.println(String.valueOf(i + 1) + " \"" + (i + 1) + "\"");
            ++i;
        }
        out.println("*Arcs");
        i = 0;
        while (i < g.size()) {
            Iterator<Integer> it = g.getNeighbours(i).iterator();
            while (it.hasNext()) {
                out.println(String.valueOf(i + 1) + " " + (it.next() + 1) + " 1");
            }
            ++i;
        }
        out.println("*Edges");
    }

    public static void writeUCINET_DL(Graph g, PrintStream out) {
        out.println("DL\nN=" + g.size() + "\nFORMAT=NODELIST\nDATA:");
        int i = 0;
        while (i < g.size()) {
            out.print(" " + (i + 1));
            Iterator<Integer> it = g.getNeighbours(i).iterator();
            while (it.hasNext()) {
                out.print(" " + (it.next() + 1));
            }
            out.println();
            ++i;
        }
        out.println();
    }

    public static void writeUCINET_DLMatrix(Graph g, PrintStream out) {
        out.println("DL\nN=" + g.size() + "\nDATA:");
        int i = 0;
        while (i < g.size()) {
            BitSet bs = new BitSet(g.size());
            Iterator<Integer> it = g.getNeighbours(i).iterator();
            while (it.hasNext()) {
                bs.set(it.next());
            }
            int j = 0;
            while (j < g.size()) {
                out.print(bs.get(j) ? " 1" : " 0");
                ++j;
            }
            out.println();
            ++i;
        }
        out.println();
    }

    public static void writeChaco(Graph g, PrintStream out) {
        if (g.directed()) {
            System.err.println("warning: you're saving a directed graph in Chaco format");
        }
        long edges = 0L;
        int i = 0;
        while (i < g.size()) {
            edges += (long)g.getNeighbours(i).size();
            ++i;
        }
        out.println(String.valueOf(g.size()) + " " + edges / 2L);
        i = 0;
        while (i < g.size()) {
            Iterator<Integer> it = g.getNeighbours(i).iterator();
            while (it.hasNext()) {
                out.print(String.valueOf(it.next() + 1) + " ");
            }
            out.println();
            ++i;
        }
        out.println();
    }

    public static Graph readNewscastGraph(String file, int direction) throws IOException {
        NeighborListGraph gr = new NeighborListGraph(direction != 2);
        FileInputStream fis = new FileInputStream(file);
        DataInputStream dis = new DataInputStream(fis);
        dis.readByte();
        dis.readByte();
        dis.readByte();
        int MODE = dis.readInt();
        if (MODE != 1) {
            throw new IOException("Unknown mode " + MODE);
        }
        int CACHESIZE = dis.readInt();
        int GRAPHSIZE = dis.readInt();
        int i = 1;
        while (i <= GRAPHSIZE) {
            int iind = gr.addNode(new Integer(i));
            int j = 0;
            while (j < CACHESIZE) {
                int a = dis.readInt();
                dis.readLong();
                int agentIndex = gr.addNode(new Integer(a));
                if (direction == 0) {
                    gr.setEdge(iind, agentIndex);
                } else {
                    gr.setEdge(agentIndex, iind);
                }
                ++j;
            }
            ++i;
        }
        dis.close();
        return gr;
    }
}

