/*
 * Decompiled with CFR 0.152.
 */
package peernet.graph;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import peernet.graph.Graph;

public class NeighborListGraph
implements Graph,
Serializable {
    private final ArrayList<Object> nodes;
    private final HashMap<Object, Integer> nodeindex;
    private final ArrayList<Set<Integer>> neighbors;
    private final boolean directed;

    public NeighborListGraph(boolean directed) {
        this.nodes = new ArrayList(1000);
        this.neighbors = new ArrayList(1000);
        this.nodeindex = new HashMap(1000);
        this.directed = directed;
    }

    public NeighborListGraph(int size, boolean directed) {
        this.nodes = null;
        this.neighbors = new ArrayList(size);
        int i = 0;
        while (i < size) {
            this.neighbors.add(new HashSet());
            ++i;
        }
        this.nodeindex = null;
        this.directed = directed;
    }

    public int addNode(Object o) {
        Integer index = this.nodeindex.get(o);
        if (index == null) {
            index = new Integer(this.nodes.size());
            this.nodes.add(o);
            this.neighbors.add(new HashSet());
            this.nodeindex.put(o, index);
        }
        return index;
    }

    @Override
    public boolean setEdge(int i, int j) {
        boolean ret = this.neighbors.get(i).add(j);
        if (ret && !this.directed) {
            this.neighbors.get(j).add(i);
        }
        return ret;
    }

    @Override
    public boolean clearEdge(int i, int j) {
        boolean ret = this.neighbors.get(i).remove(j);
        if (ret && !this.directed) {
            this.neighbors.get(j).remove(i);
        }
        return ret;
    }

    @Override
    public boolean isEdge(int i, int j) {
        return this.neighbors.get(i).contains(j);
    }

    @Override
    public Collection<Integer> getNeighbours(int i) {
        return Collections.unmodifiableCollection((Collection)this.neighbors.get(i));
    }

    @Override
    public Object getNode(int i) {
        return this.nodes == null ? null : this.nodes.get(i);
    }

    @Override
    public Object getEdge(int i, int j) {
        return null;
    }

    @Override
    public int size() {
        return this.neighbors.size();
    }

    @Override
    public boolean directed() {
        return this.directed;
    }

    @Override
    public int degree(int i) {
        return this.neighbors.get(i).size();
    }
}

