/*
 * Decompiled with CFR 0.152.
 */
package peernet.graph;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import peernet.graph.Graph;

public class ReverseGraph
implements Graph {
    protected final Graph g;
    protected final List<Integer>[] in;

    public ReverseGraph(Graph g) {
        this.g = g;
        this.in = !g.directed() ? null : new List[g.size()];
        this.initGraph();
    }

    protected void initGraph() {
        int max = this.g.size();
        int i = 0;
        while (i < max) {
            this.in[i] = new ArrayList<Integer>();
            ++i;
        }
        i = 0;
        while (i < max) {
            for (Integer j : this.g.getNeighbours(i)) {
                this.in[j].add(i);
            }
            ++i;
        }
    }

    @Override
    public boolean isEdge(int i, int j) {
        return this.g.isEdge(j, i);
    }

    @Override
    public Collection<Integer> getNeighbours(int i) {
        ArrayList<Integer> result = new ArrayList<Integer>();
        if (this.in != null) {
            result.addAll(this.in[i]);
        }
        return Collections.unmodifiableCollection(result);
    }

    @Override
    public Object getNode(int i) {
        return this.g.getNode(i);
    }

    @Override
    public Object getEdge(int i, int j) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int size() {
        return this.g.size();
    }

    @Override
    public boolean directed() {
        return this.g.directed();
    }

    @Override
    public boolean setEdge(int i, int j) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean clearEdge(int i, int j) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int degree(int i) {
        return this.in == null ? 0 : this.in[i].size();
    }
}

