/*
 * Decompiled with CFR 0.152.
 */
package peernet.graph;

import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import peernet.graph.Graph;

public class SubGraphEdges
implements Graph {
    private final Graph g;
    private final BitSet nodes;

    public SubGraphEdges(Graph g) {
        this.g = g;
        this.nodes = new BitSet(g.size());
    }

    @Override
    public boolean isEdge(int i, int j) {
        return this.nodes.get(i) && this.nodes.get(j) && this.g.isEdge(i, j);
    }

    @Override
    public Collection<Integer> getNeighbours(int i) {
        LinkedList<Integer> result = new LinkedList<Integer>();
        if (this.nodes.get(i)) {
            for (Integer in : this.g.getNeighbours(i)) {
                if (!this.nodes.get(in)) continue;
                result.add(in);
            }
        }
        return Collections.unmodifiableCollection(result);
    }

    @Override
    public Object getNode(int i) {
        return this.g.getNode(i);
    }

    @Override
    public Object getEdge(int i, int j) {
        if (this.isEdge(i, j)) {
            return this.g.getEdge(i, j);
        }
        return null;
    }

    @Override
    public int size() {
        return this.g.size();
    }

    @Override
    public boolean directed() {
        return this.g.directed();
    }

    @Override
    public boolean setEdge(int i, int j) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean clearEdge(int i, int j) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int degree(int i) {
        int degree = 0;
        if (this.nodes.get(i)) {
            for (Integer in : this.g.getNeighbours(i)) {
                if (!this.nodes.get(in)) continue;
                ++degree;
            }
        }
        return degree;
    }

    public int subGraphSize() {
        return this.nodes.cardinality();
    }

    public boolean removeNode(int i) {
        boolean was = this.nodes.get(i);
        this.nodes.clear(i);
        return was;
    }

    public boolean addNode(int i) {
        boolean was = this.nodes.get(i);
        this.nodes.set(i);
        return was;
    }
}

