/*
 * Decompiled with CFR 0.152.
 */
package peernet.graph;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import peernet.graph.Graph;

public class UndirectedGraph
implements Graph {
    private final Graph g;

    public UndirectedGraph(Graph g) {
        this.g = g;
    }

    @Override
    public boolean isEdge(int i, int j) {
        return this.g.isEdge(i, j) || this.g.isEdge(j, i);
    }

    @Override
    public Collection<Integer> getNeighbours(int i) {
        HashSet<Integer> result = new HashSet<Integer>();
        result.addAll(this.g.getNeighbours(i));
        int max = this.g.size();
        int j = 0;
        while (j < max) {
            if (this.g.isEdge(j, i)) {
                result.add(new Integer(j));
            }
            ++j;
        }
        return Collections.unmodifiableCollection(result);
    }

    @Override
    public Object getNode(int i) {
        return this.g.getNode(i);
    }

    @Override
    public Object getEdge(int i, int j) {
        if (this.g.isEdge(i, j)) {
            return this.g.getEdge(i, j);
        }
        if (this.g.isEdge(j, i)) {
            return this.g.getEdge(j, i);
        }
        return null;
    }

    @Override
    public int size() {
        return this.g.size();
    }

    @Override
    public boolean directed() {
        return false;
    }

    @Override
    public boolean setEdge(int i, int j) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean clearEdge(int i, int j) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int degree(int i) {
        return this.getNeighbours(i).size();
    }
}

