/*
 * Decompiled with CFR 0.152.
 */
package peernet.reports;

import peernet.config.Configuration;
import peernet.core.CommonState;
import peernet.core.Network;
import peernet.reports.GraphObserver;
import peernet.util.IncrementalStats;
import peernet.util.RandPermutation;

public class BallExpansion
extends GraphObserver {
    private static final String PAR_MAXD = "maxd";
    private static final String PAR_N = "n";
    private static final String PAR_STATS = "stats";
    private final int maxd;
    private final int n;
    private final boolean stats;
    private final int[] b;
    private final RandPermutation rp = new RandPermutation(CommonState.r);

    public BallExpansion(String name) {
        super(name);
        this.maxd = Configuration.getInt(String.valueOf(name) + "." + PAR_MAXD, Network.size());
        this.n = Configuration.getInt(String.valueOf(name) + "." + PAR_N, 1000);
        this.stats = Configuration.contains(String.valueOf(name) + "." + PAR_STATS);
        this.b = new int[this.maxd];
    }

    @Override
    public boolean execute() {
        this.startObservation();
        this.updateGraph();
        this.rp.reset(this.g.size());
        if (this.stats) {
            IncrementalStats is = new IncrementalStats();
            int i = 0;
            while (i < this.n && i < this.g.size()) {
                this.ga.dist(this.g, this.rp.next());
                int j = 0;
                while (j < this.g.size()) {
                    if (this.ga.d[j] > 0) {
                        is.add(this.ga.d[j]);
                    } else if (this.ga.d[j] == -1) {
                        is.add(Double.POSITIVE_INFINITY);
                    }
                    ++j;
                }
                ++i;
            }
            this.output(is);
        } else {
            int i = 0;
            while (i < this.n && i < this.g.size()) {
                this.ga.flooding(this.g, this.b, this.rp.next());
                int j = 0;
                int numReached = 0;
                while (j < this.b.length && this.b[j] > 0) {
                    numReached += this.b[j];
                    ++j;
                }
                this.output(String.valueOf(Network.size()) + this.separator + numReached);
                ++i;
            }
        }
        this.stopObservation();
        return false;
    }
}

