/*
 * Decompiled with CFR 0.152.
 */
package peernet.reports;

import java.util.Iterator;
import java.util.Map;
import peernet.config.Configuration;
import peernet.reports.GraphObserver;
import peernet.util.IncrementalStats;

public class ConnectivityObserver
extends GraphObserver {
    private static final String PAR_STATS = "stats";
    private static final String PAR_TYPE = "type";
    private final boolean sizestats;
    private final String type;

    public ConnectivityObserver(String name) {
        super(name);
        this.sizestats = Configuration.contains(String.valueOf(name) + "." + PAR_STATS);
        this.type = Configuration.getString(String.valueOf(name) + "." + PAR_TYPE, "wcc");
    }

    @Override
    public boolean execute() {
        Map clst;
        this.startObservation();
        this.updateGraph();
        if (this.type.equals("wcc")) {
            clst = this.ga.weaklyConnectedClusters(this.g);
        } else if (this.type.equals("scc")) {
            clst = this.ga.tarjan(this.g);
        } else {
            throw new RuntimeException("Unsupported connted cluster type '" + this.type + "'");
        }
        if (!this.sizestats) {
            this.output(clst.toString());
        } else {
            IncrementalStats stats = new IncrementalStats();
            Iterator it = clst.values().iterator();
            while (it.hasNext()) {
                stats.add(((Integer)it.next()).intValue());
            }
            this.output(stats);
        }
        this.stopObservation();
        return false;
    }
}

