/*
 * Decompiled with CFR 0.152.
 */
package peernet.reports;

import peernet.config.Configuration;
import peernet.graph.GraphAlgorithms;
import peernet.reports.GraphObserver;
import peernet.util.IncrementalStats;

public class GraphStats
extends GraphObserver {
    private static final String PAR_NL = "nl";
    private static final String PAR_NC = "nc";
    private final int nc;
    private final int nl;

    public GraphStats(String name) {
        super(name);
        this.nl = Configuration.getInt(String.valueOf(name) + "." + PAR_NL, 0);
        this.nc = Configuration.getInt(String.valueOf(name) + "." + PAR_NC, 0);
    }

    @Override
    public boolean execute() {
        int i;
        int n;
        this.startObservation();
        IncrementalStats stats = new IncrementalStats();
        this.updateGraph();
        if (this.nc != 0) {
            stats.reset();
            n = this.nc < 0 ? this.g.size() : this.nc;
            i = 0;
            while (i < n && i < this.g.size()) {
                stats.add(GraphAlgorithms.clustering(this.g, i));
                ++i;
            }
            this.output(String.valueOf(stats.getAverage()) + this.separator);
        }
        if (this.nl != 0) {
            stats.reset();
            n = this.nl < 0 ? this.g.size() : this.nl;
            i = 0;
            block1: while (i < n && i < this.g.size()) {
                this.ga.dist(this.g, i);
                int j = 0;
                while (j < this.g.size()) {
                    if (j != i) {
                        if (this.ga.d[j] == -1) {
                            stats.add(Double.POSITIVE_INFINITY);
                            break block1;
                        }
                        stats.add(this.ga.d[j]);
                    }
                    ++j;
                }
                ++i;
            }
            this.output("" + stats.getAverage());
        }
        this.stopObservation();
        return false;
    }
}

