/*
 * Decompiled with CFR 0.152.
 */
package peernet.reports;

import java.util.Iterator;
import java.util.Map;
import peernet.config.Configuration;
import peernet.core.Network;
import peernet.graph.PrefixSubGraph;
import peernet.reports.GraphObserver;
import peernet.util.IncrementalStats;

public class RandRemoval
extends GraphObserver {
    private static final String PAR_N = "n";
    private final int n;

    public RandRemoval(String name) {
        super(name);
        this.n = Configuration.getInt(String.valueOf(name) + "." + PAR_N, 1);
    }

    @Override
    public boolean execute() {
        if (this.n <= 1) {
            return false;
        }
        this.startObservation();
        this.updateGraph();
        int size = Network.size();
        int steps = 50;
        IncrementalStats[] maxClust = new IncrementalStats[50];
        IncrementalStats[] clustNum = new IncrementalStats[50];
        int i = 0;
        while (i < 50) {
            maxClust[i] = new IncrementalStats();
            clustNum[i] = new IncrementalStats();
            ++i;
        }
        int j = 0;
        while (j < this.n) {
            PrefixSubGraph sg = new PrefixSubGraph(this.g);
            IncrementalStats stats = new IncrementalStats();
            int i2 = 0;
            while (i2 < 50) {
                sg.setSize(size / 2 - i2 * (size / 100));
                Map clst = this.ga.weaklyConnectedClusters(sg);
                stats.reset();
                Iterator it = clst.values().iterator();
                while (it.hasNext()) {
                    stats.add(((Integer)it.next()).intValue());
                }
                maxClust[i2].add(stats.getMax());
                clustNum[i2].add(clst.size());
                ++i2;
            }
            if (j + 1 < this.n) {
                Network.shuffle();
            }
            ++j;
        }
        i = 0;
        while (i < 50) {
            this.output(String.valueOf(maxClust[i].getAverage()) + " " + clustNum[i].getAverage());
            ++i;
        }
        this.stopObservation();
        return false;
    }
}

