/*
 * Decompiled with CFR 0.152.
 */
package peernet.transport;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.StringTokenizer;
import peernet.config.Configuration;
import peernet.config.IllegalParameterException;
import peernet.core.Control;
import peernet.transport.RouterNetwork;

public class KingParser2
implements Control {
    private static final String PAR_FILE = "file";
    private static final String PAR_RATIO = "ratio";
    private String filename;
    private double ratio;
    private String prefix;

    public KingParser2(String prefix) {
        this.prefix = prefix;
        this.ratio = Configuration.getDouble(String.valueOf(prefix) + "." + PAR_RATIO, 1.0);
        this.filename = Configuration.getString(String.valueOf(prefix) + "." + PAR_FILE, null);
    }

    @Override
    public boolean execute() {
        BufferedReader in = null;
        if (this.filename != null) {
            try {
                in = new BufferedReader(new FileReader(this.filename));
            }
            catch (FileNotFoundException e) {
                throw new IllegalParameterException(String.valueOf(this.prefix) + "." + PAR_FILE, String.valueOf(this.filename) + " does not exist");
            }
        } else {
            in = new BufferedReader(new InputStreamReader(ClassLoader.getSystemResourceAsStream("t-king.map")));
        }
        String line = null;
        int size = 1740;
        RouterNetwork.reset(size, true);
        System.err.println("KingParser: read " + size + " entries");
        try {
            line = in.readLine();
            int row = 0;
            int col = 0;
            do {
                StringTokenizer tok = new StringTokenizer(line, " ");
                col = 0;
                do {
                    double latency;
                    int lat = (latency = Double.parseDouble(tok.nextToken())) < 0.0 ? 100 : (int)(latency * this.ratio);
                    if (row != col) {
                        RouterNetwork.setLatency(row, col, lat);
                    }
                    ++col;
                } while (tok.hasMoreTokens());
                ++row;
            } while ((line = in.readLine()) != null);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return false;
    }
}

