/*
 * Decompiled with CFR 0.152.
 */
package peernet.transport;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.StringTokenizer;
import peernet.config.Configuration;
import peernet.config.IllegalParameterException;
import peernet.core.Control;
import peernet.transport.RouterNetwork;

public class MeridianParser
implements Control {
    private static final String PAR_FILE = "file";
    private static final String PAR_RATIO = "ratio";
    private static final String PAR_SIZE = "size";
    private String filename;
    private double ratio;
    private String prefix;
    private int size = 0;

    public MeridianParser(String prefix) {
        this.prefix = prefix;
        this.ratio = Configuration.getDouble(String.valueOf(prefix) + "." + PAR_RATIO, 1.0);
        this.filename = Configuration.getString(String.valueOf(prefix) + "." + PAR_FILE, null);
        this.size = Configuration.getInt(String.valueOf(prefix) + "." + PAR_SIZE);
    }

    @Override
    public boolean execute() {
        BufferedReader in = null;
        if (this.filename != null) {
            try {
                in = new BufferedReader(new FileReader(this.filename));
            }
            catch (FileNotFoundException e) {
                throw new IllegalParameterException(String.valueOf(this.prefix) + "." + PAR_FILE, String.valueOf(this.filename) + " does not exist");
            }
        } else {
            in = new BufferedReader(new InputStreamReader(ClassLoader.getSystemResourceAsStream("t-king.map")));
        }
        RouterNetwork.reset(this.size, true);
        System.err.println("MeridianParser: going to read " + this.size + " entries");
        try {
            String line = null;
            while ((line = in.readLine()) != null) {
                StringTokenizer tok = new StringTokenizer(line, "\t");
                int n1 = Integer.parseInt(tok.nextToken()) - 1;
                int n2 = Integer.parseInt(tok.nextToken()) - 1;
                int latency = (int)(Double.parseDouble(tok.nextToken()) * this.ratio);
                int mod = latency % 1000;
                latency = 1000 * (latency / 1000);
                if (mod >= 500) {
                    latency += 1000;
                }
                System.err.println(String.valueOf(n1) + "\t" + n2 + "\t" + latency);
                RouterNetwork.setLatency(n1, n2, latency);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }
}

