/*
 * Decompiled with CFR 0.152.
 */
package peernet.transport;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import peernet.core.Linkable;
import peernet.core.Network;
import peernet.core.Node;
import peernet.core.Peer;
import peernet.graph.Graph;
import peernet.transport.AddressSim;

public class OverlayGraph
implements Graph {
    public final int protocolID;
    public final boolean wireDirected;

    public OverlayGraph(int protocolID) {
        this.protocolID = protocolID;
        this.wireDirected = true;
    }

    public OverlayGraph(int protocolID, boolean wireDirected) {
        this.protocolID = protocolID;
        this.wireDirected = wireDirected;
    }

    @Override
    public boolean isEdge(int i, int j) {
        if (i < 0 || j < 0 || !Network.get(i).isUp() || !Network.get(j).isUp()) {
            return false;
        }
        Linkable l = (Linkable)((Object)Network.get(i).getProtocol(this.protocolID));
        Peer d = Network.get(j).getProtocol(this.protocolID).myPeer();
        return l.contains(d);
    }

    @Override
    public Collection<Integer> getNeighbours(int i) {
        Linkable l = (Linkable)((Object)Network.get(i).getProtocol(this.protocolID));
        ArrayList<Integer> al = new ArrayList<Integer>(l.degree());
        int j = 0;
        while (j < l.degree()) {
            Node n = ((AddressSim)l.getNeighbor((int)j).address).node;
            al.add(new Integer(n.getIndex()));
            ++j;
        }
        return Collections.unmodifiableList(al);
    }

    @Override
    public Object getNode(int i) {
        return Network.get(i);
    }

    @Override
    public Object getEdge(int i, int j) {
        return null;
    }

    @Override
    public int size() {
        return Network.size();
    }

    @Override
    public boolean directed() {
        return true;
    }

    @Override
    public boolean setEdge(int i, int j) {
        if (!this.wireDirected) {
            Linkable protocol_j = (Linkable)((Object)Network.get(j).getProtocol(this.protocolID));
            Peer peer_i = Network.get(i).getProtocol(this.protocolID).myPeer();
            protocol_j.addNeighbor(peer_i);
        }
        Linkable protocol_i = (Linkable)((Object)Network.get(i).getProtocol(this.protocolID));
        Peer peer_j = Network.get(j).getProtocol(this.protocolID).myPeer();
        protocol_i.addNeighbor(peer_j);
        return true;
    }

    @Override
    public boolean clearEdge(int i, int j) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int degree(int i) {
        if (!Network.get(i).isUp()) {
            return 0;
        }
        Linkable l = (Linkable)((Object)Network.get(i).getProtocol(this.protocolID));
        int numNeighbors = 0;
        int j = 0;
        while (j < l.degree()) {
            Node n = ((AddressSim)l.getNeighbor((int)j).address).node;
            if (n.isUp()) {
                ++numNeighbors;
            }
            ++j;
        }
        return numNeighbors;
    }

    public int fullDegree(int i) {
        if (!Network.get(i).isUp()) {
            return 0;
        }
        Linkable l = (Linkable)((Object)Network.get(i).getProtocol(this.protocolID));
        return l.degree();
    }
}

