/*
 * Decompiled with CFR 0.152.
 */
package peernet.transport;

import peernet.config.Configuration;
import peernet.core.Engine;
import peernet.core.Node;
import peernet.transport.Address;
import peernet.transport.AddressSim;
import peernet.transport.RouterNetwork;
import peernet.transport.Transport;

public class TransportEmu
extends Transport {
    private static final String PAR_LOCAL = "local";
    private int local;
    private Engine engine;

    public TransportEmu(String prefix) {
        this.local = Configuration.getInt(String.valueOf(prefix) + "." + PAR_LOCAL, 0);
        this.engine = Engine.instance();
        assert (Engine.getAddressType() == Engine.AddressType.SIM);
    }

    @Override
    public void send(Node src, Address dest, int pid, Object payload) {
        int senderRouter = (int)src.getID() % RouterNetwork.getSize();
        int receiverRouter = dest.hashCode() % RouterNetwork.getSize();
        AddressSim senderAddress = new AddressSim(src);
        int latency = RouterNetwork.getLatency(senderRouter, receiverRouter) + this.local * 2;
        if (latency >= 0) {
            this.addEventIn(latency, senderAddress, ((AddressSim)dest).node, pid, payload);
        }
    }

    @Override
    public Object clone() {
        return this;
    }
}

