/*
 * Decompiled with CFR 0.152.
 */
package peernet.transport;

import peernet.config.Configuration;
import peernet.config.IllegalParameterException;
import peernet.core.CommonState;
import peernet.core.Node;
import peernet.transport.Address;
import peernet.transport.AddressSim;
import peernet.transport.Transport;

public class UniformRandomTransport
extends Transport {
    private static final String PAR_MINDELAY = "mindelay";
    private static final String PAR_MAXDELAY = "maxdelay";
    private final long min;
    private final long range;

    public UniformRandomTransport(String prefix) {
        this.min = Configuration.getLong(String.valueOf(prefix) + "." + PAR_MINDELAY, 0L);
        long max = Configuration.getLong(String.valueOf(prefix) + "." + PAR_MAXDELAY, this.min);
        if (max < this.min) {
            throw new IllegalParameterException(String.valueOf(prefix) + "." + PAR_MAXDELAY, "The maximum latency cannot be smaller than the minimum latency");
        }
        this.range = max - this.min + 1L;
    }

    @Override
    public Object clone() {
        return this;
    }

    @Override
    public void send(Node src, Address dest, int pid, Object payload) {
        long delay = this.range == 1L ? this.min : this.min + CommonState.r.nextLong(this.range);
        AddressSim senderAddress = new AddressSim(src);
        this.addEventIn(delay, senderAddress, ((AddressSim)dest).node, pid, payload);
    }
}

