/*
 * Decompiled with CFR 0.152.
 */
package peernet.util;

import java.io.PrintStream;

public class IncrementalFreq
implements Cloneable {
    private int n;
    private int min;
    private int max;
    private double sum;
    private int[] freq = null;
    private final int N;

    public IncrementalFreq(int maxvalue) {
        this.N = maxvalue + 1;
        this.reset();
    }

    public IncrementalFreq() {
        this(-1);
    }

    public void reset() {
        if (this.freq == null || this.N == 0) {
            this.freq = new int[0];
        } else {
            int i = 0;
            while (i < this.freq.length) {
                this.freq[i] = 0;
                ++i;
            }
        }
        this.n = 0;
    }

    public final void add(int i) {
        this.add(i, 1);
    }

    public void add(int i, int k) {
        if (this.N > 0 && i >= this.N) {
            return;
        }
        if (i < 0 || k <= 0) {
            return;
        }
        this.n += k;
        if (i < this.min) {
            this.min = i;
        }
        if (i > this.max) {
            this.max = i;
        }
        this.sum += (double)(i * k);
        if (i >= this.freq.length) {
            int[] tmp = new int[i + 1];
            System.arraycopy(this.freq, 0, tmp, 0, this.freq.length);
            this.freq = tmp;
        }
        int n = i;
        this.freq[n] = this.freq[n] + k;
    }

    public int getN() {
        return this.n;
    }

    public int getFreq(int i) {
        if (i >= 0 && i < this.freq.length) {
            return this.freq[i];
        }
        return 0;
    }

    public int getMax() {
        return this.max;
    }

    public int getMin() {
        return this.min;
    }

    public double getSum() {
        return this.sum;
    }

    public double getAverage() {
        return this.sum / (double)this.n;
    }

    public void remove(IncrementalFreq other, boolean strict) {
        if (strict && other.freq.length > this.freq.length) {
            int i = other.freq.length - 1;
            while (i >= this.freq.length) {
                if (other.freq[i] != 0) {
                    throw new IllegalArgumentException();
                }
                --i;
            }
        }
        int minLength = Math.min(other.freq.length, this.freq.length);
        int i = minLength - 1;
        while (i >= 0) {
            if (strict && this.freq[i] < other.freq[i]) {
                throw new IllegalArgumentException();
            }
            int remove = Math.min(other.freq[i], this.freq[i]);
            this.n -= remove;
            int n = i;
            this.freq[n] = this.freq[n] - remove;
            this.sum -= (double)(i * remove);
            --i;
        }
        this.min = Integer.MAX_VALUE;
        i = this.freq.length - 1;
        while (i >= 0) {
            if (this.freq[i] > 0) {
                this.max = i;
                break;
            }
            --i;
        }
        this.max = Integer.MIN_VALUE;
        i = 0;
        while (i < this.freq.length - 1) {
            if (this.freq[i] > 0) {
                this.min = i;
                break;
            }
            ++i;
        }
    }

    public void printAll(PrintStream out) {
        int i = 0;
        while (i < this.freq.length) {
            out.println(String.valueOf(i) + " " + this.freq[i]);
            ++i;
        }
    }

    public void print(PrintStream out) {
        int i = 0;
        while (i < this.freq.length) {
            if (this.freq[i] != 0) {
                out.println(String.valueOf(i) + " " + this.freq[i]);
            }
            ++i;
        }
    }

    public String toString(String separator) {
        String result = "";
        int i = 0;
        while (i < this.freq.length) {
            if (this.freq[i] != 0) {
                result = String.valueOf(result) + "\n" + i + separator + this.freq[i];
            }
            ++i;
        }
        return result;
    }

    public String toString() {
        String result = "";
        int i = 0;
        while (i < this.freq.length) {
            if (this.freq[i] != 0) {
                result = String.valueOf(result) + " (" + i + "," + this.freq[i] + ")";
            }
            ++i;
        }
        return result;
    }

    public String toArithmeticExpression() {
        String result = "";
        int i = this.freq.length - 1;
        while (i >= 0) {
            if (this.freq[i] != 0) {
                result = String.valueOf(result) + this.freq[i] + "*" + i + "+";
            }
            --i;
        }
        result = result.equals("") ? "(empty)" : result.substring(0, result.length() - 1);
        return result;
    }

    public Object clone() throws CloneNotSupportedException {
        IncrementalFreq result = (IncrementalFreq)super.clone();
        if (this.freq != null) {
            result.freq = (int[])this.freq.clone();
        }
        return result;
    }

    public boolean equals(Object obj) {
        IncrementalFreq other = (IncrementalFreq)obj;
        int minlength = Math.min(other.freq.length, this.freq.length);
        int i = minlength - 1;
        while (i >= 0) {
            if (this.freq[i] != other.freq[i]) {
                return false;
            }
            --i;
        }
        if (this.freq.length > minlength) {
            other = this;
        }
        i = minlength;
        while (i < other.freq.length) {
            if (other.freq[i] != 0) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

