/*
 * Decompiled with CFR 0.152.
 */
package peernet.util;

import java.util.ArrayList;
import java.util.Collections;
import peernet.util.IncrementalStats;

public class MedianStats
extends IncrementalStats {
    private ArrayList<Double> data;

    public MedianStats() {
        this.reset();
    }

    public double getMedian() {
        double result;
        if (this.data.isEmpty()) {
            throw new IllegalStateException("Data vector is empty!");
        }
        Collections.sort(this.data);
        if (this.data.size() % 2 != 0) {
            int index = Math.round(this.data.size() / 2);
            result = this.data.get(index);
        } else {
            double a = this.data.get(this.data.size() / 2);
            double b = this.data.get(this.data.size() / 2 - 1);
            result = (a + b) / 2.0;
        }
        return result;
    }

    @Override
    public void add(double item, int k) {
        int i = 0;
        while (i < k) {
            super.add(item, 1);
            this.data.add(new Double(item));
            ++i;
        }
    }

    @Override
    public void reset() {
        super.reset();
        if (this.data != null) {
            this.data.clear();
        }
    }
}

